/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.TaskStatistics;

@SdkInternalApi
public class TaskStatisticsMarshaller {
    private static final MarshallingInfo<Integer> TOTALCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalChecks").build();
    private static final MarshallingInfo<Integer> INPROGRESSCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inProgressChecks").build();
    private static final MarshallingInfo<Integer> WAITINGFORDATACOLLECTIONCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("waitingForDataCollectionChecks").build();
    private static final MarshallingInfo<Integer> COMPLIANTCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("compliantChecks").build();
    private static final MarshallingInfo<Integer> NONCOMPLIANTCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonCompliantChecks").build();
    private static final MarshallingInfo<Integer> FAILEDCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failedChecks").build();
    private static final MarshallingInfo<Integer> CANCELEDCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("canceledChecks").build();
    private static final TaskStatisticsMarshaller instance = new TaskStatisticsMarshaller();

    public static TaskStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaskStatistics taskStatistics, ProtocolMarshaller protocolMarshaller) {
        if (taskStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taskStatistics.getTotalChecks(), TOTALCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.getInProgressChecks(), INPROGRESSCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.getWaitingForDataCollectionChecks(), WAITINGFORDATACOLLECTIONCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.getCompliantChecks(), COMPLIANTCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.getNonCompliantChecks(), NONCOMPLIANTCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.getFailedChecks(), FAILEDCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.getCanceledChecks(), CANCELEDCHECKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

