/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.AlertTarget;
import com.amazonaws.services.iot.model.Behavior;
import com.amazonaws.services.iot.model.MetricToRetain;
import com.amazonaws.services.iot.model.MetricsExportConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSecurityProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String securityProfileName;
    private String securityProfileDescription;
    private List<Behavior> behaviors;
    private Map<String, AlertTarget> alertTargets;
    @Deprecated
    private List<String> additionalMetricsToRetain;
    private List<MetricToRetain> additionalMetricsToRetainV2;
    private Boolean deleteBehaviors;
    private Boolean deleteAlertTargets;
    private Boolean deleteAdditionalMetricsToRetain;
    private Long expectedVersion;
    private MetricsExportConfig metricsExportConfig;
    private Boolean deleteMetricsExportConfig;

    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    public String getSecurityProfileName() {
        return this.securityProfileName;
    }

    public UpdateSecurityProfileRequest withSecurityProfileName(String securityProfileName) {
        this.setSecurityProfileName(securityProfileName);
        return this;
    }

    public void setSecurityProfileDescription(String securityProfileDescription) {
        this.securityProfileDescription = securityProfileDescription;
    }

    public String getSecurityProfileDescription() {
        return this.securityProfileDescription;
    }

    public UpdateSecurityProfileRequest withSecurityProfileDescription(String securityProfileDescription) {
        this.setSecurityProfileDescription(securityProfileDescription);
        return this;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(Collection<Behavior> behaviors) {
        if (behaviors == null) {
            this.behaviors = null;
            return;
        }
        this.behaviors = new ArrayList<Behavior>(behaviors);
    }

    public UpdateSecurityProfileRequest withBehaviors(Behavior ... behaviors) {
        if (this.behaviors == null) {
            this.setBehaviors(new ArrayList<Behavior>(behaviors.length));
        }
        for (Behavior ele : behaviors) {
            this.behaviors.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileRequest withBehaviors(Collection<Behavior> behaviors) {
        this.setBehaviors(behaviors);
        return this;
    }

    public Map<String, AlertTarget> getAlertTargets() {
        return this.alertTargets;
    }

    public void setAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.alertTargets = alertTargets;
    }

    public UpdateSecurityProfileRequest withAlertTargets(Map<String, AlertTarget> alertTargets) {
        this.setAlertTargets(alertTargets);
        return this;
    }

    public UpdateSecurityProfileRequest addAlertTargetsEntry(String key, AlertTarget value) {
        if (null == this.alertTargets) {
            this.alertTargets = new HashMap<String, AlertTarget>();
        }
        if (this.alertTargets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.alertTargets.put(key, value);
        return this;
    }

    public UpdateSecurityProfileRequest clearAlertTargetsEntries() {
        this.alertTargets = null;
        return this;
    }

    @Deprecated
    public List<String> getAdditionalMetricsToRetain() {
        return this.additionalMetricsToRetain;
    }

    @Deprecated
    public void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
        if (additionalMetricsToRetain == null) {
            this.additionalMetricsToRetain = null;
            return;
        }
        this.additionalMetricsToRetain = new ArrayList<String>(additionalMetricsToRetain);
    }

    @Deprecated
    public UpdateSecurityProfileRequest withAdditionalMetricsToRetain(String ... additionalMetricsToRetain) {
        if (this.additionalMetricsToRetain == null) {
            this.setAdditionalMetricsToRetain(new ArrayList<String>(additionalMetricsToRetain.length));
        }
        for (String ele : additionalMetricsToRetain) {
            this.additionalMetricsToRetain.add(ele);
        }
        return this;
    }

    @Deprecated
    public UpdateSecurityProfileRequest withAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
        this.setAdditionalMetricsToRetain(additionalMetricsToRetain);
        return this;
    }

    public List<MetricToRetain> getAdditionalMetricsToRetainV2() {
        return this.additionalMetricsToRetainV2;
    }

    public void setAdditionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
        if (additionalMetricsToRetainV2 == null) {
            this.additionalMetricsToRetainV2 = null;
            return;
        }
        this.additionalMetricsToRetainV2 = new ArrayList<MetricToRetain>(additionalMetricsToRetainV2);
    }

    public UpdateSecurityProfileRequest withAdditionalMetricsToRetainV2(MetricToRetain ... additionalMetricsToRetainV2) {
        if (this.additionalMetricsToRetainV2 == null) {
            this.setAdditionalMetricsToRetainV2(new ArrayList<MetricToRetain>(additionalMetricsToRetainV2.length));
        }
        for (MetricToRetain ele : additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileRequest withAdditionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
        this.setAdditionalMetricsToRetainV2(additionalMetricsToRetainV2);
        return this;
    }

    public void setDeleteBehaviors(Boolean deleteBehaviors) {
        this.deleteBehaviors = deleteBehaviors;
    }

    public Boolean getDeleteBehaviors() {
        return this.deleteBehaviors;
    }

    public UpdateSecurityProfileRequest withDeleteBehaviors(Boolean deleteBehaviors) {
        this.setDeleteBehaviors(deleteBehaviors);
        return this;
    }

    public Boolean isDeleteBehaviors() {
        return this.deleteBehaviors;
    }

    public void setDeleteAlertTargets(Boolean deleteAlertTargets) {
        this.deleteAlertTargets = deleteAlertTargets;
    }

    public Boolean getDeleteAlertTargets() {
        return this.deleteAlertTargets;
    }

    public UpdateSecurityProfileRequest withDeleteAlertTargets(Boolean deleteAlertTargets) {
        this.setDeleteAlertTargets(deleteAlertTargets);
        return this;
    }

    public Boolean isDeleteAlertTargets() {
        return this.deleteAlertTargets;
    }

    public void setDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
        this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
    }

    public Boolean getDeleteAdditionalMetricsToRetain() {
        return this.deleteAdditionalMetricsToRetain;
    }

    public UpdateSecurityProfileRequest withDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
        this.setDeleteAdditionalMetricsToRetain(deleteAdditionalMetricsToRetain);
        return this;
    }

    public Boolean isDeleteAdditionalMetricsToRetain() {
        return this.deleteAdditionalMetricsToRetain;
    }

    public void setExpectedVersion(Long expectedVersion) {
        this.expectedVersion = expectedVersion;
    }

    public Long getExpectedVersion() {
        return this.expectedVersion;
    }

    public UpdateSecurityProfileRequest withExpectedVersion(Long expectedVersion) {
        this.setExpectedVersion(expectedVersion);
        return this;
    }

    public void setMetricsExportConfig(MetricsExportConfig metricsExportConfig) {
        this.metricsExportConfig = metricsExportConfig;
    }

    public MetricsExportConfig getMetricsExportConfig() {
        return this.metricsExportConfig;
    }

    public UpdateSecurityProfileRequest withMetricsExportConfig(MetricsExportConfig metricsExportConfig) {
        this.setMetricsExportConfig(metricsExportConfig);
        return this;
    }

    public void setDeleteMetricsExportConfig(Boolean deleteMetricsExportConfig) {
        this.deleteMetricsExportConfig = deleteMetricsExportConfig;
    }

    public Boolean getDeleteMetricsExportConfig() {
        return this.deleteMetricsExportConfig;
    }

    public UpdateSecurityProfileRequest withDeleteMetricsExportConfig(Boolean deleteMetricsExportConfig) {
        this.setDeleteMetricsExportConfig(deleteMetricsExportConfig);
        return this;
    }

    public Boolean isDeleteMetricsExportConfig() {
        return this.deleteMetricsExportConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityProfileName() != null) {
            sb.append("SecurityProfileName: ").append(this.getSecurityProfileName()).append(",");
        }
        if (this.getSecurityProfileDescription() != null) {
            sb.append("SecurityProfileDescription: ").append(this.getSecurityProfileDescription()).append(",");
        }
        if (this.getBehaviors() != null) {
            sb.append("Behaviors: ").append(this.getBehaviors()).append(",");
        }
        if (this.getAlertTargets() != null) {
            sb.append("AlertTargets: ").append(this.getAlertTargets()).append(",");
        }
        if (this.getAdditionalMetricsToRetain() != null) {
            sb.append("AdditionalMetricsToRetain: ").append(this.getAdditionalMetricsToRetain()).append(",");
        }
        if (this.getAdditionalMetricsToRetainV2() != null) {
            sb.append("AdditionalMetricsToRetainV2: ").append(this.getAdditionalMetricsToRetainV2()).append(",");
        }
        if (this.getDeleteBehaviors() != null) {
            sb.append("DeleteBehaviors: ").append(this.getDeleteBehaviors()).append(",");
        }
        if (this.getDeleteAlertTargets() != null) {
            sb.append("DeleteAlertTargets: ").append(this.getDeleteAlertTargets()).append(",");
        }
        if (this.getDeleteAdditionalMetricsToRetain() != null) {
            sb.append("DeleteAdditionalMetricsToRetain: ").append(this.getDeleteAdditionalMetricsToRetain()).append(",");
        }
        if (this.getExpectedVersion() != null) {
            sb.append("ExpectedVersion: ").append(this.getExpectedVersion()).append(",");
        }
        if (this.getMetricsExportConfig() != null) {
            sb.append("MetricsExportConfig: ").append(this.getMetricsExportConfig()).append(",");
        }
        if (this.getDeleteMetricsExportConfig() != null) {
            sb.append("DeleteMetricsExportConfig: ").append(this.getDeleteMetricsExportConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest)obj;
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null) {
            return false;
        }
        if (other.getSecurityProfileName() != null && !other.getSecurityProfileName().equals(this.getSecurityProfileName())) {
            return false;
        }
        if (other.getSecurityProfileDescription() == null ^ this.getSecurityProfileDescription() == null) {
            return false;
        }
        if (other.getSecurityProfileDescription() != null && !other.getSecurityProfileDescription().equals(this.getSecurityProfileDescription())) {
            return false;
        }
        if (other.getBehaviors() == null ^ this.getBehaviors() == null) {
            return false;
        }
        if (other.getBehaviors() != null && !other.getBehaviors().equals(this.getBehaviors())) {
            return false;
        }
        if (other.getAlertTargets() == null ^ this.getAlertTargets() == null) {
            return false;
        }
        if (other.getAlertTargets() != null && !other.getAlertTargets().equals(this.getAlertTargets())) {
            return false;
        }
        if (other.getAdditionalMetricsToRetain() == null ^ this.getAdditionalMetricsToRetain() == null) {
            return false;
        }
        if (other.getAdditionalMetricsToRetain() != null && !other.getAdditionalMetricsToRetain().equals(this.getAdditionalMetricsToRetain())) {
            return false;
        }
        if (other.getAdditionalMetricsToRetainV2() == null ^ this.getAdditionalMetricsToRetainV2() == null) {
            return false;
        }
        if (other.getAdditionalMetricsToRetainV2() != null && !other.getAdditionalMetricsToRetainV2().equals(this.getAdditionalMetricsToRetainV2())) {
            return false;
        }
        if (other.getDeleteBehaviors() == null ^ this.getDeleteBehaviors() == null) {
            return false;
        }
        if (other.getDeleteBehaviors() != null && !other.getDeleteBehaviors().equals(this.getDeleteBehaviors())) {
            return false;
        }
        if (other.getDeleteAlertTargets() == null ^ this.getDeleteAlertTargets() == null) {
            return false;
        }
        if (other.getDeleteAlertTargets() != null && !other.getDeleteAlertTargets().equals(this.getDeleteAlertTargets())) {
            return false;
        }
        if (other.getDeleteAdditionalMetricsToRetain() == null ^ this.getDeleteAdditionalMetricsToRetain() == null) {
            return false;
        }
        if (other.getDeleteAdditionalMetricsToRetain() != null && !other.getDeleteAdditionalMetricsToRetain().equals(this.getDeleteAdditionalMetricsToRetain())) {
            return false;
        }
        if (other.getExpectedVersion() == null ^ this.getExpectedVersion() == null) {
            return false;
        }
        if (other.getExpectedVersion() != null && !other.getExpectedVersion().equals(this.getExpectedVersion())) {
            return false;
        }
        if (other.getMetricsExportConfig() == null ^ this.getMetricsExportConfig() == null) {
            return false;
        }
        if (other.getMetricsExportConfig() != null && !other.getMetricsExportConfig().equals(this.getMetricsExportConfig())) {
            return false;
        }
        if (other.getDeleteMetricsExportConfig() == null ^ this.getDeleteMetricsExportConfig() == null) {
            return false;
        }
        return other.getDeleteMetricsExportConfig() == null || other.getDeleteMetricsExportConfig().equals(this.getDeleteMetricsExportConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityProfileName() == null ? 0 : this.getSecurityProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileDescription() == null ? 0 : this.getSecurityProfileDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBehaviors() == null ? 0 : this.getBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getAlertTargets() == null ? 0 : this.getAlertTargets().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMetricsToRetain() == null ? 0 : this.getAdditionalMetricsToRetain().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMetricsToRetainV2() == null ? 0 : this.getAdditionalMetricsToRetainV2().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteBehaviors() == null ? 0 : this.getDeleteBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteAlertTargets() == null ? 0 : this.getDeleteAlertTargets().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteAdditionalMetricsToRetain() == null ? 0 : this.getDeleteAdditionalMetricsToRetain().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedVersion() == null ? 0 : this.getExpectedVersion().hashCode());
        hashCode = 31 * hashCode + (this.getMetricsExportConfig() == null ? 0 : this.getMetricsExportConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteMetricsExportConfig() == null ? 0 : this.getDeleteMetricsExportConfig().hashCode());
        return hashCode;
    }

    public UpdateSecurityProfileRequest clone() {
        return (UpdateSecurityProfileRequest)super.clone();
    }
}

