/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.ViolationEvent;
import java.util.Date;

@SdkInternalApi
public class ViolationEventMarshaller {
    private static final MarshallingInfo<String> VIOLATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationId").build();
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").build();
    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileName").build();
    private static final MarshallingInfo<StructuredPojo> BEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behavior").build();
    private static final MarshallingInfo<StructuredPojo> METRICVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").build();
    private static final MarshallingInfo<StructuredPojo> VIOLATIONEVENTADDITIONALINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventAdditionalInfo").build();
    private static final MarshallingInfo<String> VIOLATIONEVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventType").build();
    private static final MarshallingInfo<String> VERIFICATIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("verificationState").build();
    private static final MarshallingInfo<String> VERIFICATIONSTATEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("verificationStateDescription").build();
    private static final MarshallingInfo<Date> VIOLATIONEVENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventTime").timestampFormat("unixTimestamp").build();
    private static final ViolationEventMarshaller instance = new ViolationEventMarshaller();

    public static ViolationEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(ViolationEvent violationEvent, ProtocolMarshaller protocolMarshaller) {
        if (violationEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)violationEvent.getViolationId(), VIOLATIONID_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getThingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getSecurityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getBehavior(), BEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getMetricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getViolationEventAdditionalInfo(), VIOLATIONEVENTADDITIONALINFO_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getViolationEventType(), VIOLATIONEVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getVerificationState(), VERIFICATIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getVerificationStateDescription(), VERIFICATIONSTATEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.getViolationEventTime(), VIOLATIONEVENTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

