/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.Bucket;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetBucketsAggregationResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Integer totalCount;
    private List<Bucket> buckets;

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public GetBucketsAggregationResult withTotalCount(Integer totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Collection<Bucket> buckets) {
        if (buckets == null) {
            this.buckets = null;
            return;
        }
        this.buckets = new ArrayList<Bucket>(buckets);
    }

    public GetBucketsAggregationResult withBuckets(Bucket ... buckets) {
        if (this.buckets == null) {
            this.setBuckets(new ArrayList<Bucket>(buckets.length));
        }
        for (Bucket ele : buckets) {
            this.buckets.add(ele);
        }
        return this;
    }

    public GetBucketsAggregationResult withBuckets(Collection<Bucket> buckets) {
        this.setBuckets(buckets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount()).append(",");
        }
        if (this.getBuckets() != null) {
            sb.append("Buckets: ").append(this.getBuckets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsAggregationResult)) {
            return false;
        }
        GetBucketsAggregationResult other = (GetBucketsAggregationResult)obj;
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        if (other.getTotalCount() != null && !other.getTotalCount().equals(this.getTotalCount())) {
            return false;
        }
        if (other.getBuckets() == null ^ this.getBuckets() == null) {
            return false;
        }
        return other.getBuckets() == null || other.getBuckets().equals(this.getBuckets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        hashCode = 31 * hashCode + (this.getBuckets() == null ? 0 : this.getBuckets().hashCode());
        return hashCode;
    }

    public GetBucketsAggregationResult clone() {
        try {
            return (GetBucketsAggregationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

