/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.iot.model.ListThingTypesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListThingTypesRequestMarshaller
implements Marshaller<Request<ListThingTypesRequest>, ListThingTypesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListThingTypesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListThingTypesRequest> marshall(ListThingTypesRequest listThingTypesRequest) {
        if (listThingTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listThingTypesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/thing-types";
        request.setResourcePath(uriResourcePath);
        if (listThingTypesRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listThingTypesRequest.getNextToken()));
        }
        if (listThingTypesRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listThingTypesRequest.getMaxResults()));
        }
        if (listThingTypesRequest.getThingTypeName() != null) {
            request.addParameter("thingTypeName", StringUtils.fromString((String)listThingTypesRequest.getThingTypeName()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

