/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PublishRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        if (publishRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/topics/{topic}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "topic", publishRequest.getTopic());
        request.setResourcePath(uriResourcePath);
        if (publishRequest.getQos() != null) {
            request.addParameter("qos", StringUtils.fromInteger((Integer)publishRequest.getQos()));
        }
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)publishRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

