/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.CreatePolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreatePolicyVersionRequestMarshaller
implements Marshaller<Request<CreatePolicyVersionRequest>, CreatePolicyVersionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreatePolicyVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreatePolicyVersionRequest> marshall(CreatePolicyVersionRequest createPolicyVersionRequest) {
        if (createPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/policies/{policyName}/version";
        uriResourcePath = uriResourcePath.replace("{policyName}", createPolicyVersionRequest.getPolicyName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createPolicyVersionRequest.getPolicyName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (createPolicyVersionRequest.getSetAsDefault() != null) {
            request.addParameter("setAsDefault", StringUtils.fromBoolean((Boolean)createPolicyVersionRequest.getSetAsDefault()));
        }
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPolicyVersionRequest.getPolicyDocument() != null) {
                jsonGenerator.writeFieldName("policyDocument").writeValue(createPolicyVersionRequest.getPolicyDocument());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

