/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.Stream;
import com.amazonaws.services.iot.model.transform.CodeSigningSignatureMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class CodeSigningSignature
implements Serializable,
Cloneable,
StructuredPojo {
    private Stream stream;
    private ByteBuffer inlineDocument;

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public Stream getStream() {
        return this.stream;
    }

    public CodeSigningSignature withStream(Stream stream) {
        this.setStream(stream);
        return this;
    }

    public void setInlineDocument(ByteBuffer inlineDocument) {
        this.inlineDocument = inlineDocument;
    }

    public ByteBuffer getInlineDocument() {
        return this.inlineDocument;
    }

    public CodeSigningSignature withInlineDocument(ByteBuffer inlineDocument) {
        this.setInlineDocument(inlineDocument);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStream() != null) {
            sb.append("Stream: ").append(this.getStream()).append(",");
        }
        if (this.getInlineDocument() != null) {
            sb.append("InlineDocument: ").append(this.getInlineDocument());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningSignature)) {
            return false;
        }
        CodeSigningSignature other = (CodeSigningSignature)obj;
        if (other.getStream() == null ^ this.getStream() == null) {
            return false;
        }
        if (other.getStream() != null && !other.getStream().equals(this.getStream())) {
            return false;
        }
        if (other.getInlineDocument() == null ^ this.getInlineDocument() == null) {
            return false;
        }
        return other.getInlineDocument() == null || other.getInlineDocument().equals(this.getInlineDocument());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStream() == null ? 0 : this.getStream().hashCode());
        hashCode = 31 * hashCode + (this.getInlineDocument() == null ? 0 : this.getInlineDocument().hashCode());
        return hashCode;
    }

    public CodeSigningSignature clone() {
        try {
            return (CodeSigningSignature)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeSigningSignatureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

