/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRule;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class TopicRuleJsonMarshaller {
    private static TopicRuleJsonMarshaller instance;

    public void marshall(TopicRule topicRule, StructuredJsonGenerator jsonGenerator) {
        if (topicRule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Action> actionsList;
            jsonGenerator.writeStartObject();
            if (topicRule.getRuleName() != null) {
                jsonGenerator.writeFieldName("ruleName").writeValue(topicRule.getRuleName());
            }
            if (topicRule.getSql() != null) {
                jsonGenerator.writeFieldName("sql").writeValue(topicRule.getSql());
            }
            if (topicRule.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(topicRule.getDescription());
            }
            if (topicRule.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(topicRule.getCreatedAt());
            }
            if ((actionsList = topicRule.getActions()) != null) {
                jsonGenerator.writeFieldName("actions");
                jsonGenerator.writeStartArray();
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (topicRule.getRuleDisabled() != null) {
                jsonGenerator.writeFieldName("ruleDisabled").writeValue(topicRule.getRuleDisabled().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TopicRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRuleJsonMarshaller();
        }
        return instance;
    }
}

