/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.AcceptCertificateTransferRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AcceptCertificateTransferRequestMarshaller
implements Marshaller<Request<AcceptCertificateTransferRequest>, AcceptCertificateTransferRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<AcceptCertificateTransferRequest> marshall(AcceptCertificateTransferRequest acceptCertificateTransferRequest) {
        if (acceptCertificateTransferRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)acceptCertificateTransferRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/accept-certificate-transfer/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", acceptCertificateTransferRequest.getCertificateId() != null ? StringUtils.fromString((String)acceptCertificateTransferRequest.getCertificateId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (acceptCertificateTransferRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean((Boolean)acceptCertificateTransferRequest.getSetAsActive()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

