/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.LoggingOptionsPayload;
import com.amazonaws.services.iot.model.SetLoggingOptionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class SetLoggingOptionsRequestMarshaller
implements Marshaller<Request<SetLoggingOptionsRequest>, SetLoggingOptionsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<SetLoggingOptionsRequest> marshall(SetLoggingOptionsRequest setLoggingOptionsRequest) {
        if (setLoggingOptionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setLoggingOptionsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/loggingOptions";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            LoggingOptionsPayload loggingOptionsPayload = setLoggingOptionsRequest.getLoggingOptionsPayload();
            if (loggingOptionsPayload != null) {
                jsonWriter.object();
                if (loggingOptionsPayload.getRoleArn() != null) {
                    jsonWriter.key("roleArn").value((Object)loggingOptionsPayload.getRoleArn());
                }
                if (loggingOptionsPayload.getLogLevel() != null) {
                    jsonWriter.key("logLevel").value((Object)loggingOptionsPayload.getLogLevel());
                }
                jsonWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

