/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPrincipalPoliciesRequestMarshaller
implements Marshaller<Request<ListPrincipalPoliciesRequest>, ListPrincipalPoliciesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListPrincipalPoliciesRequest> marshall(ListPrincipalPoliciesRequest listPrincipalPoliciesRequest) {
        String ascendingOrder;
        String pageSize;
        String marker;
        if (listPrincipalPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPrincipalPoliciesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalPoliciesRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-iot-principal", StringUtils.fromString((String)listPrincipalPoliciesRequest.getPrincipal()));
        }
        String uriResourcePath = "/principal-policies";
        request.setResourcePath(uriResourcePath);
        String string = marker = listPrincipalPoliciesRequest.getMarker() == null ? null : StringUtils.fromString((String)listPrincipalPoliciesRequest.getMarker());
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        String string2 = pageSize = listPrincipalPoliciesRequest.getPageSize() == null ? null : StringUtils.fromInteger((Integer)listPrincipalPoliciesRequest.getPageSize());
        if (pageSize != null) {
            request.addParameter("pageSize", pageSize);
        }
        String string3 = ascendingOrder = listPrincipalPoliciesRequest.getAscendingOrder() == null ? null : StringUtils.fromBoolean((Boolean)listPrincipalPoliciesRequest.getAscendingOrder());
        if (ascendingOrder != null) {
            request.addParameter("isAscendingOrder", ascendingOrder);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

