/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.UpdateCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateCertificateRequestMarshaller
implements Marshaller<Request<UpdateCertificateRequest>, UpdateCertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdateCertificateRequest> marshall(UpdateCertificateRequest updateCertificateRequest) {
        String newStatus;
        if (updateCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/certificates/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", updateCertificateRequest.getCertificateId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)updateCertificateRequest.getCertificateId()));
        request.setResourcePath(uriResourcePath);
        String string = newStatus = updateCertificateRequest.getNewStatus() == null ? null : StringUtils.fromString((String)updateCertificateRequest.getNewStatus());
        if (newStatus != null) {
            request.addParameter("newStatus", newStatus);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

