/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.internetmonitor.model.HealthEventsConfig;
import com.amazonaws.services.internetmonitor.model.InternetMeasurementsLogDelivery;
import com.amazonaws.services.internetmonitor.model.MonitorConfigState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateMonitorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String monitorName;
    private List<String> resourcesToAdd;
    private List<String> resourcesToRemove;
    private String status;
    private String clientToken;
    private Integer maxCityNetworksToMonitor;
    private InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
    private Integer trafficPercentageToMonitor;
    private HealthEventsConfig healthEventsConfig;

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public UpdateMonitorRequest withMonitorName(String monitorName) {
        this.setMonitorName(monitorName);
        return this;
    }

    public List<String> getResourcesToAdd() {
        return this.resourcesToAdd;
    }

    public void setResourcesToAdd(Collection<String> resourcesToAdd) {
        if (resourcesToAdd == null) {
            this.resourcesToAdd = null;
            return;
        }
        this.resourcesToAdd = new ArrayList<String>(resourcesToAdd);
    }

    public UpdateMonitorRequest withResourcesToAdd(String ... resourcesToAdd) {
        if (this.resourcesToAdd == null) {
            this.setResourcesToAdd(new ArrayList<String>(resourcesToAdd.length));
        }
        for (String ele : resourcesToAdd) {
            this.resourcesToAdd.add(ele);
        }
        return this;
    }

    public UpdateMonitorRequest withResourcesToAdd(Collection<String> resourcesToAdd) {
        this.setResourcesToAdd(resourcesToAdd);
        return this;
    }

    public List<String> getResourcesToRemove() {
        return this.resourcesToRemove;
    }

    public void setResourcesToRemove(Collection<String> resourcesToRemove) {
        if (resourcesToRemove == null) {
            this.resourcesToRemove = null;
            return;
        }
        this.resourcesToRemove = new ArrayList<String>(resourcesToRemove);
    }

    public UpdateMonitorRequest withResourcesToRemove(String ... resourcesToRemove) {
        if (this.resourcesToRemove == null) {
            this.setResourcesToRemove(new ArrayList<String>(resourcesToRemove.length));
        }
        for (String ele : resourcesToRemove) {
            this.resourcesToRemove.add(ele);
        }
        return this;
    }

    public UpdateMonitorRequest withResourcesToRemove(Collection<String> resourcesToRemove) {
        this.setResourcesToRemove(resourcesToRemove);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public UpdateMonitorRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public UpdateMonitorRequest withStatus(MonitorConfigState status) {
        this.status = status.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateMonitorRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
        this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
    }

    public Integer getMaxCityNetworksToMonitor() {
        return this.maxCityNetworksToMonitor;
    }

    public UpdateMonitorRequest withMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
        this.setMaxCityNetworksToMonitor(maxCityNetworksToMonitor);
        return this;
    }

    public void setInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
        this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
    }

    public InternetMeasurementsLogDelivery getInternetMeasurementsLogDelivery() {
        return this.internetMeasurementsLogDelivery;
    }

    public UpdateMonitorRequest withInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
        this.setInternetMeasurementsLogDelivery(internetMeasurementsLogDelivery);
        return this;
    }

    public void setTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
        this.trafficPercentageToMonitor = trafficPercentageToMonitor;
    }

    public Integer getTrafficPercentageToMonitor() {
        return this.trafficPercentageToMonitor;
    }

    public UpdateMonitorRequest withTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
        this.setTrafficPercentageToMonitor(trafficPercentageToMonitor);
        return this;
    }

    public void setHealthEventsConfig(HealthEventsConfig healthEventsConfig) {
        this.healthEventsConfig = healthEventsConfig;
    }

    public HealthEventsConfig getHealthEventsConfig() {
        return this.healthEventsConfig;
    }

    public UpdateMonitorRequest withHealthEventsConfig(HealthEventsConfig healthEventsConfig) {
        this.setHealthEventsConfig(healthEventsConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitorName() != null) {
            sb.append("MonitorName: ").append(this.getMonitorName()).append(",");
        }
        if (this.getResourcesToAdd() != null) {
            sb.append("ResourcesToAdd: ").append(this.getResourcesToAdd()).append(",");
        }
        if (this.getResourcesToRemove() != null) {
            sb.append("ResourcesToRemove: ").append(this.getResourcesToRemove()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getMaxCityNetworksToMonitor() != null) {
            sb.append("MaxCityNetworksToMonitor: ").append(this.getMaxCityNetworksToMonitor()).append(",");
        }
        if (this.getInternetMeasurementsLogDelivery() != null) {
            sb.append("InternetMeasurementsLogDelivery: ").append(this.getInternetMeasurementsLogDelivery()).append(",");
        }
        if (this.getTrafficPercentageToMonitor() != null) {
            sb.append("TrafficPercentageToMonitor: ").append(this.getTrafficPercentageToMonitor()).append(",");
        }
        if (this.getHealthEventsConfig() != null) {
            sb.append("HealthEventsConfig: ").append(this.getHealthEventsConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest)obj;
        if (other.getMonitorName() == null ^ this.getMonitorName() == null) {
            return false;
        }
        if (other.getMonitorName() != null && !other.getMonitorName().equals(this.getMonitorName())) {
            return false;
        }
        if (other.getResourcesToAdd() == null ^ this.getResourcesToAdd() == null) {
            return false;
        }
        if (other.getResourcesToAdd() != null && !other.getResourcesToAdd().equals(this.getResourcesToAdd())) {
            return false;
        }
        if (other.getResourcesToRemove() == null ^ this.getResourcesToRemove() == null) {
            return false;
        }
        if (other.getResourcesToRemove() != null && !other.getResourcesToRemove().equals(this.getResourcesToRemove())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getMaxCityNetworksToMonitor() == null ^ this.getMaxCityNetworksToMonitor() == null) {
            return false;
        }
        if (other.getMaxCityNetworksToMonitor() != null && !other.getMaxCityNetworksToMonitor().equals(this.getMaxCityNetworksToMonitor())) {
            return false;
        }
        if (other.getInternetMeasurementsLogDelivery() == null ^ this.getInternetMeasurementsLogDelivery() == null) {
            return false;
        }
        if (other.getInternetMeasurementsLogDelivery() != null && !other.getInternetMeasurementsLogDelivery().equals(this.getInternetMeasurementsLogDelivery())) {
            return false;
        }
        if (other.getTrafficPercentageToMonitor() == null ^ this.getTrafficPercentageToMonitor() == null) {
            return false;
        }
        if (other.getTrafficPercentageToMonitor() != null && !other.getTrafficPercentageToMonitor().equals(this.getTrafficPercentageToMonitor())) {
            return false;
        }
        if (other.getHealthEventsConfig() == null ^ this.getHealthEventsConfig() == null) {
            return false;
        }
        return other.getHealthEventsConfig() == null || other.getHealthEventsConfig().equals(this.getHealthEventsConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitorName() == null ? 0 : this.getMonitorName().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesToAdd() == null ? 0 : this.getResourcesToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesToRemove() == null ? 0 : this.getResourcesToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCityNetworksToMonitor() == null ? 0 : this.getMaxCityNetworksToMonitor().hashCode());
        hashCode = 31 * hashCode + (this.getInternetMeasurementsLogDelivery() == null ? 0 : this.getInternetMeasurementsLogDelivery().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPercentageToMonitor() == null ? 0 : this.getTrafficPercentageToMonitor().hashCode());
        hashCode = 31 * hashCode + (this.getHealthEventsConfig() == null ? 0 : this.getHealthEventsConfig().hashCode());
        return hashCode;
    }

    public UpdateMonitorRequest clone() {
        return (UpdateMonitorRequest)super.clone();
    }
}

