/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.internetmonitor.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3. The
 * configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements, and the
 * delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on whether you
 * choose to deliver internet measurements to S3 logs.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/internetmonitor-2021-06-03/S3Config" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class S3Config implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon S3 bucket name.
     * </p>
     */
    private String bucketName;
    /**
     * <p>
     * The Amazon S3 bucket prefix.
     * </p>
     */
    private String bucketPrefix;
    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     */
    private String logDeliveryStatus;

    /**
     * <p>
     * The Amazon S3 bucket name.
     * </p>
     * 
     * @param bucketName
     *        The Amazon S3 bucket name.
     */

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    /**
     * <p>
     * The Amazon S3 bucket name.
     * </p>
     * 
     * @return The Amazon S3 bucket name.
     */

    public String getBucketName() {
        return this.bucketName;
    }

    /**
     * <p>
     * The Amazon S3 bucket name.
     * </p>
     * 
     * @param bucketName
     *        The Amazon S3 bucket name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public S3Config withBucketName(String bucketName) {
        setBucketName(bucketName);
        return this;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix.
     * </p>
     * 
     * @param bucketPrefix
     *        The Amazon S3 bucket prefix.
     */

    public void setBucketPrefix(String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix.
     */

    public String getBucketPrefix() {
        return this.bucketPrefix;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix.
     * </p>
     * 
     * @param bucketPrefix
     *        The Amazon S3 bucket prefix.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public S3Config withBucketPrefix(String bucketPrefix) {
        setBucketPrefix(bucketPrefix);
        return this;
    }

    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     * 
     * @param logDeliveryStatus
     *        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * @see LogDeliveryStatus
     */

    public void setLogDeliveryStatus(String logDeliveryStatus) {
        this.logDeliveryStatus = logDeliveryStatus;
    }

    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     * 
     * @return The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * @see LogDeliveryStatus
     */

    public String getLogDeliveryStatus() {
        return this.logDeliveryStatus;
    }

    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     * 
     * @param logDeliveryStatus
     *        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogDeliveryStatus
     */

    public S3Config withLogDeliveryStatus(String logDeliveryStatus) {
        setLogDeliveryStatus(logDeliveryStatus);
        return this;
    }

    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     * 
     * @param logDeliveryStatus
     *        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogDeliveryStatus
     */

    public S3Config withLogDeliveryStatus(LogDeliveryStatus logDeliveryStatus) {
        this.logDeliveryStatus = logDeliveryStatus.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBucketName() != null)
            sb.append("BucketName: ").append(getBucketName()).append(",");
        if (getBucketPrefix() != null)
            sb.append("BucketPrefix: ").append(getBucketPrefix()).append(",");
        if (getLogDeliveryStatus() != null)
            sb.append("LogDeliveryStatus: ").append(getLogDeliveryStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof S3Config == false)
            return false;
        S3Config other = (S3Config) obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null)
            return false;
        if (other.getBucketName() != null && other.getBucketName().equals(this.getBucketName()) == false)
            return false;
        if (other.getBucketPrefix() == null ^ this.getBucketPrefix() == null)
            return false;
        if (other.getBucketPrefix() != null && other.getBucketPrefix().equals(this.getBucketPrefix()) == false)
            return false;
        if (other.getLogDeliveryStatus() == null ^ this.getLogDeliveryStatus() == null)
            return false;
        if (other.getLogDeliveryStatus() != null && other.getLogDeliveryStatus().equals(this.getLogDeliveryStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBucketName() == null) ? 0 : getBucketName().hashCode());
        hashCode = prime * hashCode + ((getBucketPrefix() == null) ? 0 : getBucketPrefix().hashCode());
        hashCode = prime * hashCode + ((getLogDeliveryStatus() == null) ? 0 : getLogDeliveryStatus().hashCode());
        return hashCode;
    }

    @Override
    public S3Config clone() {
        try {
            return (S3Config) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.internetmonitor.model.transform.S3ConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
