/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.CisScan;
import java.util.Date;

@SdkInternalApi
public class CisScanMarshaller {
    private static final MarshallingInfo<Integer> FAILEDCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failedChecks").build();
    private static final MarshallingInfo<String> SCANARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanArn").build();
    private static final MarshallingInfo<String> SCANCONFIGURATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanConfigurationArn").build();
    private static final MarshallingInfo<Date> SCANDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SCANNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanName").build();
    private static final MarshallingInfo<String> SCHEDULEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scheduledBy").build();
    private static final MarshallingInfo<String> SECURITYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityLevel").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<StructuredPojo> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").build();
    private static final MarshallingInfo<Integer> TOTALCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalChecks").build();
    private static final CisScanMarshaller instance = new CisScanMarshaller();

    public static CisScanMarshaller getInstance() {
        return instance;
    }

    public void marshall(CisScan cisScan, ProtocolMarshaller protocolMarshaller) {
        if (cisScan == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cisScan.getFailedChecks(), FAILEDCHECKS_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getScanArn(), SCANARN_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getScanConfigurationArn(), SCANCONFIGURATIONARN_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getScanDate(), SCANDATE_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getScanName(), SCANNAME_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getScheduledBy(), SCHEDULEDBY_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getSecurityLevel(), SECURITYLEVEL_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getTargets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)cisScan.getTotalChecks(), TOTALCHECKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

