/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector2.model.FreeTrialAccountInfo;
import com.amazonaws.services.inspector2.model.FreeTrialInfoError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetFreeTrialInfoResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FreeTrialAccountInfo> accounts;
    private List<FreeTrialInfoError> failedAccounts;

    public List<FreeTrialAccountInfo> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<FreeTrialAccountInfo> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new ArrayList<FreeTrialAccountInfo>(accounts);
    }

    public BatchGetFreeTrialInfoResult withAccounts(FreeTrialAccountInfo ... accounts) {
        if (this.accounts == null) {
            this.setAccounts(new ArrayList<FreeTrialAccountInfo>(accounts.length));
        }
        for (FreeTrialAccountInfo ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    public BatchGetFreeTrialInfoResult withAccounts(Collection<FreeTrialAccountInfo> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public List<FreeTrialInfoError> getFailedAccounts() {
        return this.failedAccounts;
    }

    public void setFailedAccounts(Collection<FreeTrialInfoError> failedAccounts) {
        if (failedAccounts == null) {
            this.failedAccounts = null;
            return;
        }
        this.failedAccounts = new ArrayList<FreeTrialInfoError>(failedAccounts);
    }

    public BatchGetFreeTrialInfoResult withFailedAccounts(FreeTrialInfoError ... failedAccounts) {
        if (this.failedAccounts == null) {
            this.setFailedAccounts(new ArrayList<FreeTrialInfoError>(failedAccounts.length));
        }
        for (FreeTrialInfoError ele : failedAccounts) {
            this.failedAccounts.add(ele);
        }
        return this;
    }

    public BatchGetFreeTrialInfoResult withFailedAccounts(Collection<FreeTrialInfoError> failedAccounts) {
        this.setFailedAccounts(failedAccounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts()).append(",");
        }
        if (this.getFailedAccounts() != null) {
            sb.append("FailedAccounts: ").append(this.getFailedAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFreeTrialInfoResult)) {
            return false;
        }
        BatchGetFreeTrialInfoResult other = (BatchGetFreeTrialInfoResult)obj;
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        if (other.getAccounts() != null && !other.getAccounts().equals(this.getAccounts())) {
            return false;
        }
        if (other.getFailedAccounts() == null ^ this.getFailedAccounts() == null) {
            return false;
        }
        return other.getFailedAccounts() == null || other.getFailedAccounts().equals(this.getFailedAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getFailedAccounts() == null ? 0 : this.getFailedAccounts().hashCode());
        return hashCode;
    }

    public BatchGetFreeTrialInfoResult clone() {
        try {
            return (BatchGetFreeTrialInfoResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

