/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.inspector2.AWSInspector2;
import com.amazonaws.services.inspector2.AWSInspector2ClientBuilder;
import com.amazonaws.services.inspector2.model.AWSInspector2Exception;
import com.amazonaws.services.inspector2.model.AssociateMemberRequest;
import com.amazonaws.services.inspector2.model.AssociateMemberResult;
import com.amazonaws.services.inspector2.model.BatchGetAccountStatusRequest;
import com.amazonaws.services.inspector2.model.BatchGetAccountStatusResult;
import com.amazonaws.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import com.amazonaws.services.inspector2.model.BatchGetFreeTrialInfoResult;
import com.amazonaws.services.inspector2.model.CancelFindingsReportRequest;
import com.amazonaws.services.inspector2.model.CancelFindingsReportResult;
import com.amazonaws.services.inspector2.model.CreateFilterRequest;
import com.amazonaws.services.inspector2.model.CreateFilterResult;
import com.amazonaws.services.inspector2.model.CreateFindingsReportRequest;
import com.amazonaws.services.inspector2.model.CreateFindingsReportResult;
import com.amazonaws.services.inspector2.model.DeleteFilterRequest;
import com.amazonaws.services.inspector2.model.DeleteFilterResult;
import com.amazonaws.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import com.amazonaws.services.inspector2.model.DescribeOrganizationConfigurationResult;
import com.amazonaws.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import com.amazonaws.services.inspector2.model.DisableDelegatedAdminAccountResult;
import com.amazonaws.services.inspector2.model.DisableRequest;
import com.amazonaws.services.inspector2.model.DisableResult;
import com.amazonaws.services.inspector2.model.DisassociateMemberRequest;
import com.amazonaws.services.inspector2.model.DisassociateMemberResult;
import com.amazonaws.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import com.amazonaws.services.inspector2.model.EnableDelegatedAdminAccountResult;
import com.amazonaws.services.inspector2.model.EnableRequest;
import com.amazonaws.services.inspector2.model.EnableResult;
import com.amazonaws.services.inspector2.model.GetDelegatedAdminAccountRequest;
import com.amazonaws.services.inspector2.model.GetDelegatedAdminAccountResult;
import com.amazonaws.services.inspector2.model.GetFindingsReportStatusRequest;
import com.amazonaws.services.inspector2.model.GetFindingsReportStatusResult;
import com.amazonaws.services.inspector2.model.GetMemberRequest;
import com.amazonaws.services.inspector2.model.GetMemberResult;
import com.amazonaws.services.inspector2.model.ListAccountPermissionsRequest;
import com.amazonaws.services.inspector2.model.ListAccountPermissionsResult;
import com.amazonaws.services.inspector2.model.ListCoverageRequest;
import com.amazonaws.services.inspector2.model.ListCoverageResult;
import com.amazonaws.services.inspector2.model.ListCoverageStatisticsRequest;
import com.amazonaws.services.inspector2.model.ListCoverageStatisticsResult;
import com.amazonaws.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import com.amazonaws.services.inspector2.model.ListDelegatedAdminAccountsResult;
import com.amazonaws.services.inspector2.model.ListFiltersRequest;
import com.amazonaws.services.inspector2.model.ListFiltersResult;
import com.amazonaws.services.inspector2.model.ListFindingAggregationsRequest;
import com.amazonaws.services.inspector2.model.ListFindingAggregationsResult;
import com.amazonaws.services.inspector2.model.ListFindingsRequest;
import com.amazonaws.services.inspector2.model.ListFindingsResult;
import com.amazonaws.services.inspector2.model.ListMembersRequest;
import com.amazonaws.services.inspector2.model.ListMembersResult;
import com.amazonaws.services.inspector2.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector2.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector2.model.ListUsageTotalsRequest;
import com.amazonaws.services.inspector2.model.ListUsageTotalsResult;
import com.amazonaws.services.inspector2.model.TagResourceRequest;
import com.amazonaws.services.inspector2.model.TagResourceResult;
import com.amazonaws.services.inspector2.model.UntagResourceRequest;
import com.amazonaws.services.inspector2.model.UntagResourceResult;
import com.amazonaws.services.inspector2.model.UpdateFilterRequest;
import com.amazonaws.services.inspector2.model.UpdateFilterResult;
import com.amazonaws.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import com.amazonaws.services.inspector2.model.UpdateOrganizationConfigurationResult;
import com.amazonaws.services.inspector2.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.AssociateMemberRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.AssociateMemberResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.BatchGetAccountStatusRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.BatchGetAccountStatusResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.BatchGetFreeTrialInfoRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.BatchGetFreeTrialInfoResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.CancelFindingsReportRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.CancelFindingsReportResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.CreateFilterRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.CreateFilterResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.CreateFindingsReportRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.CreateFindingsReportResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.DeleteFilterRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.DeleteFilterResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.DescribeOrganizationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.DescribeOrganizationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.DisableDelegatedAdminAccountRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.DisableDelegatedAdminAccountResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.DisableRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.DisableResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.DisassociateMemberRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.DisassociateMemberResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.EnableDelegatedAdminAccountRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.EnableDelegatedAdminAccountResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.EnableRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.EnableResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.GetDelegatedAdminAccountRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.GetDelegatedAdminAccountResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.GetFindingsReportStatusRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.GetFindingsReportStatusResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.GetMemberRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.GetMemberResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListAccountPermissionsRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListAccountPermissionsResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListCoverageRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListCoverageResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListCoverageStatisticsRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListCoverageStatisticsResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListDelegatedAdminAccountsRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListDelegatedAdminAccountsResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListFiltersRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListFiltersResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListFindingAggregationsRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListFindingAggregationsResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListFindingsRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListMembersRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListMembersResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ListUsageTotalsRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.ListUsageTotalsResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.UpdateFilterRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.UpdateFilterResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.UpdateOrganizationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.inspector2.model.transform.UpdateOrganizationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.inspector2.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSInspector2Client
extends AmazonWebServiceClient
implements AWSInspector2 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSInspector2.class);
    private static final String DEFAULT_SIGNING_NAME = "inspector2";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSInspector2Exception.class));

    public static AWSInspector2ClientBuilder builder() {
        return AWSInspector2ClientBuilder.standard();
    }

    AWSInspector2Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSInspector2Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("inspector2.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/inspector2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/inspector2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateMemberResult associateMember(AssociateMemberRequest request) {
        request = (AssociateMemberRequest)this.beforeClientExecution(request);
        return this.executeAssociateMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateMemberResult executeAssociateMember(AssociateMemberRequest associateMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateMemberRequestProtocolMarshaller(protocolFactory).marshall((AssociateMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateMemberResult associateMemberResult = (AssociateMemberResult)response.getAwsResponse();
            return associateMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetAccountStatusResult batchGetAccountStatus(BatchGetAccountStatusRequest request) {
        request = (BatchGetAccountStatusRequest)this.beforeClientExecution(request);
        return this.executeBatchGetAccountStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetAccountStatusResult executeBatchGetAccountStatus(BatchGetAccountStatusRequest batchGetAccountStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetAccountStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetAccountStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetAccountStatusRequestProtocolMarshaller(protocolFactory).marshall((BatchGetAccountStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetAccountStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetAccountStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetAccountStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetAccountStatusResult batchGetAccountStatusResult = (BatchGetAccountStatusResult)response.getAwsResponse();
            return batchGetAccountStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetFreeTrialInfoResult batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest request) {
        request = (BatchGetFreeTrialInfoRequest)this.beforeClientExecution(request);
        return this.executeBatchGetFreeTrialInfo(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetFreeTrialInfoResult executeBatchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest batchGetFreeTrialInfoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetFreeTrialInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetFreeTrialInfoRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetFreeTrialInfoRequestProtocolMarshaller(protocolFactory).marshall((BatchGetFreeTrialInfoRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetFreeTrialInfoRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetFreeTrialInfo");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetFreeTrialInfoResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetFreeTrialInfoResult batchGetFreeTrialInfoResult = (BatchGetFreeTrialInfoResult)response.getAwsResponse();
            return batchGetFreeTrialInfoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelFindingsReportResult cancelFindingsReport(CancelFindingsReportRequest request) {
        request = (CancelFindingsReportRequest)this.beforeClientExecution(request);
        return this.executeCancelFindingsReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelFindingsReportResult executeCancelFindingsReport(CancelFindingsReportRequest cancelFindingsReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelFindingsReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelFindingsReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelFindingsReportRequestProtocolMarshaller(protocolFactory).marshall((CancelFindingsReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelFindingsReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelFindingsReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelFindingsReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelFindingsReportResult cancelFindingsReportResult = (CancelFindingsReportResult)response.getAwsResponse();
            return cancelFindingsReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFilterResult createFilter(CreateFilterRequest request) {
        request = (CreateFilterRequest)this.beforeClientExecution(request);
        return this.executeCreateFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFilterResult executeCreateFilter(CreateFilterRequest createFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFilterRequestProtocolMarshaller(protocolFactory).marshall((CreateFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFilterResult createFilterResult = (CreateFilterResult)response.getAwsResponse();
            return createFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFindingsReportResult createFindingsReport(CreateFindingsReportRequest request) {
        request = (CreateFindingsReportRequest)this.beforeClientExecution(request);
        return this.executeCreateFindingsReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFindingsReportResult executeCreateFindingsReport(CreateFindingsReportRequest createFindingsReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFindingsReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFindingsReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFindingsReportRequestProtocolMarshaller(protocolFactory).marshall((CreateFindingsReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFindingsReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFindingsReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFindingsReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFindingsReportResult createFindingsReportResult = (CreateFindingsReportResult)response.getAwsResponse();
            return createFindingsReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFilterResult deleteFilter(DeleteFilterRequest request) {
        request = (DeleteFilterRequest)this.beforeClientExecution(request);
        return this.executeDeleteFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFilterResult executeDeleteFilter(DeleteFilterRequest deleteFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFilterRequestProtocolMarshaller(protocolFactory).marshall((DeleteFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFilterResult deleteFilterResult = (DeleteFilterResult)response.getAwsResponse();
            return deleteFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOrganizationConfigurationResult describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest request) {
        request = (DescribeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeOrganizationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOrganizationConfigurationResult executeDescribeOrganizationConfiguration(DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOrganizationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOrganizationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOrganizationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeOrganizationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeOrganizationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeOrganizationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOrganizationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOrganizationConfigurationResult describeOrganizationConfigurationResult = (DescribeOrganizationConfigurationResult)response.getAwsResponse();
            return describeOrganizationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableResult disable(DisableRequest request) {
        request = (DisableRequest)this.beforeClientExecution(request);
        return this.executeDisable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableResult executeDisable(DisableRequest disableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableRequestProtocolMarshaller(protocolFactory).marshall((DisableRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Disable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableResult disableResult = (DisableResult)response.getAwsResponse();
            return disableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableDelegatedAdminAccountResult disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest request) {
        request = (DisableDelegatedAdminAccountRequest)this.beforeClientExecution(request);
        return this.executeDisableDelegatedAdminAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableDelegatedAdminAccountResult executeDisableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest disableDelegatedAdminAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDelegatedAdminAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDelegatedAdminAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDelegatedAdminAccountRequestProtocolMarshaller(protocolFactory).marshall((DisableDelegatedAdminAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableDelegatedAdminAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableDelegatedAdminAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableDelegatedAdminAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableDelegatedAdminAccountResult disableDelegatedAdminAccountResult = (DisableDelegatedAdminAccountResult)response.getAwsResponse();
            return disableDelegatedAdminAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateMemberResult disassociateMember(DisassociateMemberRequest request) {
        request = (DisassociateMemberRequest)this.beforeClientExecution(request);
        return this.executeDisassociateMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateMemberResult executeDisassociateMember(DisassociateMemberRequest disassociateMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateMemberRequestProtocolMarshaller(protocolFactory).marshall((DisassociateMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateMemberResult disassociateMemberResult = (DisassociateMemberResult)response.getAwsResponse();
            return disassociateMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableResult enable(EnableRequest request) {
        request = (EnableRequest)this.beforeClientExecution(request);
        return this.executeEnable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableResult executeEnable(EnableRequest enableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableRequestProtocolMarshaller(protocolFactory).marshall((EnableRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Enable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableResult enableResult = (EnableResult)response.getAwsResponse();
            return enableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableDelegatedAdminAccountResult enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest request) {
        request = (EnableDelegatedAdminAccountRequest)this.beforeClientExecution(request);
        return this.executeEnableDelegatedAdminAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableDelegatedAdminAccountResult executeEnableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest enableDelegatedAdminAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDelegatedAdminAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDelegatedAdminAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDelegatedAdminAccountRequestProtocolMarshaller(protocolFactory).marshall((EnableDelegatedAdminAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableDelegatedAdminAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableDelegatedAdminAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableDelegatedAdminAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableDelegatedAdminAccountResult enableDelegatedAdminAccountResult = (EnableDelegatedAdminAccountResult)response.getAwsResponse();
            return enableDelegatedAdminAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDelegatedAdminAccountResult getDelegatedAdminAccount(GetDelegatedAdminAccountRequest request) {
        request = (GetDelegatedAdminAccountRequest)this.beforeClientExecution(request);
        return this.executeGetDelegatedAdminAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDelegatedAdminAccountResult executeGetDelegatedAdminAccount(GetDelegatedAdminAccountRequest getDelegatedAdminAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDelegatedAdminAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDelegatedAdminAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDelegatedAdminAccountRequestProtocolMarshaller(protocolFactory).marshall((GetDelegatedAdminAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDelegatedAdminAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDelegatedAdminAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDelegatedAdminAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDelegatedAdminAccountResult getDelegatedAdminAccountResult = (GetDelegatedAdminAccountResult)response.getAwsResponse();
            return getDelegatedAdminAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFindingsReportStatusResult getFindingsReportStatus(GetFindingsReportStatusRequest request) {
        request = (GetFindingsReportStatusRequest)this.beforeClientExecution(request);
        return this.executeGetFindingsReportStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFindingsReportStatusResult executeGetFindingsReportStatus(GetFindingsReportStatusRequest getFindingsReportStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFindingsReportStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFindingsReportStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFindingsReportStatusRequestProtocolMarshaller(protocolFactory).marshall((GetFindingsReportStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFindingsReportStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFindingsReportStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsReportStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFindingsReportStatusResult getFindingsReportStatusResult = (GetFindingsReportStatusResult)response.getAwsResponse();
            return getFindingsReportStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMemberResult getMember(GetMemberRequest request) {
        request = (GetMemberRequest)this.beforeClientExecution(request);
        return this.executeGetMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMemberResult executeGetMember(GetMemberRequest getMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMemberRequestProtocolMarshaller(protocolFactory).marshall((GetMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMemberResult getMemberResult = (GetMemberResult)response.getAwsResponse();
            return getMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccountPermissionsResult listAccountPermissions(ListAccountPermissionsRequest request) {
        request = (ListAccountPermissionsRequest)this.beforeClientExecution(request);
        return this.executeListAccountPermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccountPermissionsResult executeListAccountPermissions(ListAccountPermissionsRequest listAccountPermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccountPermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccountPermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccountPermissionsRequestProtocolMarshaller(protocolFactory).marshall((ListAccountPermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAccountPermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAccountPermissions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAccountPermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAccountPermissionsResult listAccountPermissionsResult = (ListAccountPermissionsResult)response.getAwsResponse();
            return listAccountPermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCoverageResult listCoverage(ListCoverageRequest request) {
        request = (ListCoverageRequest)this.beforeClientExecution(request);
        return this.executeListCoverage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCoverageResult executeListCoverage(ListCoverageRequest listCoverageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCoverageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCoverageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCoverageRequestProtocolMarshaller(protocolFactory).marshall((ListCoverageRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCoverageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCoverage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCoverageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCoverageResult listCoverageResult = (ListCoverageResult)response.getAwsResponse();
            return listCoverageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCoverageStatisticsResult listCoverageStatistics(ListCoverageStatisticsRequest request) {
        request = (ListCoverageStatisticsRequest)this.beforeClientExecution(request);
        return this.executeListCoverageStatistics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCoverageStatisticsResult executeListCoverageStatistics(ListCoverageStatisticsRequest listCoverageStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCoverageStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCoverageStatisticsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCoverageStatisticsRequestProtocolMarshaller(protocolFactory).marshall((ListCoverageStatisticsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCoverageStatisticsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCoverageStatistics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCoverageStatisticsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCoverageStatisticsResult listCoverageStatisticsResult = (ListCoverageStatisticsResult)response.getAwsResponse();
            return listCoverageStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDelegatedAdminAccountsResult listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest request) {
        request = (ListDelegatedAdminAccountsRequest)this.beforeClientExecution(request);
        return this.executeListDelegatedAdminAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDelegatedAdminAccountsResult executeListDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDelegatedAdminAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDelegatedAdminAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDelegatedAdminAccountsRequestProtocolMarshaller(protocolFactory).marshall((ListDelegatedAdminAccountsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDelegatedAdminAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDelegatedAdminAccounts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDelegatedAdminAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDelegatedAdminAccountsResult listDelegatedAdminAccountsResult = (ListDelegatedAdminAccountsResult)response.getAwsResponse();
            return listDelegatedAdminAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFiltersResult listFilters(ListFiltersRequest request) {
        request = (ListFiltersRequest)this.beforeClientExecution(request);
        return this.executeListFilters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFiltersResult executeListFilters(ListFiltersRequest listFiltersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFiltersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFiltersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFiltersRequestProtocolMarshaller(protocolFactory).marshall((ListFiltersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFiltersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFilters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFiltersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFiltersResult listFiltersResult = (ListFiltersResult)response.getAwsResponse();
            return listFiltersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFindingAggregationsResult listFindingAggregations(ListFindingAggregationsRequest request) {
        request = (ListFindingAggregationsRequest)this.beforeClientExecution(request);
        return this.executeListFindingAggregations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFindingAggregationsResult executeListFindingAggregations(ListFindingAggregationsRequest listFindingAggregationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingAggregationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingAggregationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingAggregationsRequestProtocolMarshaller(protocolFactory).marshall((ListFindingAggregationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFindingAggregationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFindingAggregations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingAggregationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFindingAggregationsResult listFindingAggregationsResult = (ListFindingAggregationsResult)response.getAwsResponse();
            return listFindingAggregationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFindingsResult listFindings(ListFindingsRequest request) {
        request = (ListFindingsRequest)this.beforeClientExecution(request);
        return this.executeListFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFindingsResult executeListFindings(ListFindingsRequest listFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsRequestProtocolMarshaller(protocolFactory).marshall((ListFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFindingsResult listFindingsResult = (ListFindingsResult)response.getAwsResponse();
            return listFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        request = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executeListMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMembersResult executeListMembers(ListMembersRequest listMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMembersRequestProtocolMarshaller(protocolFactory).marshall((ListMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMembersResult listMembersResult = (ListMembersResult)response.getAwsResponse();
            return listMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUsageTotalsResult listUsageTotals(ListUsageTotalsRequest request) {
        request = (ListUsageTotalsRequest)this.beforeClientExecution(request);
        return this.executeListUsageTotals(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUsageTotalsResult executeListUsageTotals(ListUsageTotalsRequest listUsageTotalsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUsageTotalsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUsageTotalsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUsageTotalsRequestProtocolMarshaller(protocolFactory).marshall((ListUsageTotalsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUsageTotalsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUsageTotals");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsageTotalsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUsageTotalsResult listUsageTotalsResult = (ListUsageTotalsResult)response.getAwsResponse();
            return listUsageTotalsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFilterResult updateFilter(UpdateFilterRequest request) {
        request = (UpdateFilterRequest)this.beforeClientExecution(request);
        return this.executeUpdateFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFilterResult executeUpdateFilter(UpdateFilterRequest updateFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFilterRequestProtocolMarshaller(protocolFactory).marshall((UpdateFilterRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateFilter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFilterResult updateFilterResult = (UpdateFilterResult)response.getAwsResponse();
            return updateFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateOrganizationConfigurationResult updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest request) {
        request = (UpdateOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateOrganizationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateOrganizationConfigurationResult executeUpdateOrganizationConfiguration(UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateOrganizationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateOrganizationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateOrganizationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateOrganizationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateOrganizationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Inspector2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateOrganizationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateOrganizationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateOrganizationConfigurationResult updateOrganizationConfigurationResult = (UpdateOrganizationConfigurationResult)response.getAwsResponse();
            return updateOrganizationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

