/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe;
import com.amazonaws.services.imagebuilder.model.transform.LifecyclePolicyResourceSelectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LifecyclePolicyResourceSelection
implements Serializable,
Cloneable,
StructuredPojo {
    private List<LifecyclePolicyResourceSelectionRecipe> recipes;
    private Map<String, String> tagMap;

    public List<LifecyclePolicyResourceSelectionRecipe> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(Collection<LifecyclePolicyResourceSelectionRecipe> recipes) {
        if (recipes == null) {
            this.recipes = null;
            return;
        }
        this.recipes = new ArrayList<LifecyclePolicyResourceSelectionRecipe>(recipes);
    }

    public LifecyclePolicyResourceSelection withRecipes(LifecyclePolicyResourceSelectionRecipe ... recipes) {
        if (this.recipes == null) {
            this.setRecipes(new ArrayList<LifecyclePolicyResourceSelectionRecipe>(recipes.length));
        }
        for (LifecyclePolicyResourceSelectionRecipe ele : recipes) {
            this.recipes.add(ele);
        }
        return this;
    }

    public LifecyclePolicyResourceSelection withRecipes(Collection<LifecyclePolicyResourceSelectionRecipe> recipes) {
        this.setRecipes(recipes);
        return this;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    public void setTagMap(Map<String, String> tagMap) {
        this.tagMap = tagMap;
    }

    public LifecyclePolicyResourceSelection withTagMap(Map<String, String> tagMap) {
        this.setTagMap(tagMap);
        return this;
    }

    public LifecyclePolicyResourceSelection addTagMapEntry(String key, String value) {
        if (null == this.tagMap) {
            this.tagMap = new HashMap<String, String>();
        }
        if (this.tagMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tagMap.put(key, value);
        return this;
    }

    public LifecyclePolicyResourceSelection clearTagMapEntries() {
        this.tagMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecipes() != null) {
            sb.append("Recipes: ").append(this.getRecipes()).append(",");
        }
        if (this.getTagMap() != null) {
            sb.append("TagMap: ").append(this.getTagMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyResourceSelection)) {
            return false;
        }
        LifecyclePolicyResourceSelection other = (LifecyclePolicyResourceSelection)obj;
        if (other.getRecipes() == null ^ this.getRecipes() == null) {
            return false;
        }
        if (other.getRecipes() != null && !other.getRecipes().equals(this.getRecipes())) {
            return false;
        }
        if (other.getTagMap() == null ^ this.getTagMap() == null) {
            return false;
        }
        return other.getTagMap() == null || other.getTagMap().equals(this.getTagMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecipes() == null ? 0 : this.getRecipes().hashCode());
        hashCode = 31 * hashCode + (this.getTagMap() == null ? 0 : this.getTagMap().hashCode());
        return hashCode;
    }

    public LifecyclePolicyResourceSelection clone() {
        try {
            return (LifecyclePolicyResourceSelection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecyclePolicyResourceSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

