/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.imagebuilder.model.transform.InstanceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String image;
    private List<InstanceBlockDeviceMapping> blockDeviceMappings;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public InstanceConfiguration withImage(String image) {
        this.setImage(image);
        return this;
    }

    public List<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings);
    }

    public InstanceConfiguration withBlockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (InstanceBlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public InstanceConfiguration withBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConfiguration)) {
            return false;
        }
        InstanceConfiguration other = (InstanceConfiguration)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        return other.getBlockDeviceMappings() == null || other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        return hashCode;
    }

    public InstanceConfiguration clone() {
        try {
            return (InstanceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

