/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.imagebuilder.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Includes counts of image and pipeline resource findings by vulnerability.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/VulnerabilityIdAggregation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class VulnerabilityIdAggregation implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The vulnerability Id for this set of counts.
     * </p>
     */
    private String vulnerabilityId;
    /**
     * <p>
     * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for
     * the specified vulnerability.
     * </p>
     */
    private SeverityCounts severityCounts;

    /**
     * <p>
     * The vulnerability Id for this set of counts.
     * </p>
     * 
     * @param vulnerabilityId
     *        The vulnerability Id for this set of counts.
     */

    public void setVulnerabilityId(String vulnerabilityId) {
        this.vulnerabilityId = vulnerabilityId;
    }

    /**
     * <p>
     * The vulnerability Id for this set of counts.
     * </p>
     * 
     * @return The vulnerability Id for this set of counts.
     */

    public String getVulnerabilityId() {
        return this.vulnerabilityId;
    }

    /**
     * <p>
     * The vulnerability Id for this set of counts.
     * </p>
     * 
     * @param vulnerabilityId
     *        The vulnerability Id for this set of counts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VulnerabilityIdAggregation withVulnerabilityId(String vulnerabilityId) {
        setVulnerabilityId(vulnerabilityId);
        return this;
    }

    /**
     * <p>
     * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for
     * the specified vulnerability.
     * </p>
     * 
     * @param severityCounts
     *        Counts by severity level for medium severity and higher level findings, plus a total for all of the
     *        findings for the specified vulnerability.
     */

    public void setSeverityCounts(SeverityCounts severityCounts) {
        this.severityCounts = severityCounts;
    }

    /**
     * <p>
     * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for
     * the specified vulnerability.
     * </p>
     * 
     * @return Counts by severity level for medium severity and higher level findings, plus a total for all of the
     *         findings for the specified vulnerability.
     */

    public SeverityCounts getSeverityCounts() {
        return this.severityCounts;
    }

    /**
     * <p>
     * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for
     * the specified vulnerability.
     * </p>
     * 
     * @param severityCounts
     *        Counts by severity level for medium severity and higher level findings, plus a total for all of the
     *        findings for the specified vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VulnerabilityIdAggregation withSeverityCounts(SeverityCounts severityCounts) {
        setSeverityCounts(severityCounts);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVulnerabilityId() != null)
            sb.append("VulnerabilityId: ").append(getVulnerabilityId()).append(",");
        if (getSeverityCounts() != null)
            sb.append("SeverityCounts: ").append(getSeverityCounts());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof VulnerabilityIdAggregation == false)
            return false;
        VulnerabilityIdAggregation other = (VulnerabilityIdAggregation) obj;
        if (other.getVulnerabilityId() == null ^ this.getVulnerabilityId() == null)
            return false;
        if (other.getVulnerabilityId() != null && other.getVulnerabilityId().equals(this.getVulnerabilityId()) == false)
            return false;
        if (other.getSeverityCounts() == null ^ this.getSeverityCounts() == null)
            return false;
        if (other.getSeverityCounts() != null && other.getSeverityCounts().equals(this.getSeverityCounts()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVulnerabilityId() == null) ? 0 : getVulnerabilityId().hashCode());
        hashCode = prime * hashCode + ((getSeverityCounts() == null) ? 0 : getSeverityCounts().hashCode());
        return hashCode;
    }

    @Override
    public VulnerabilityIdAggregation clone() {
        try {
            return (VulnerabilityIdAggregation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.imagebuilder.model.transform.VulnerabilityIdAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
