/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.identitystore.AWSIdentityStore;
import com.amazonaws.services.identitystore.AWSIdentityStoreClientBuilder;
import com.amazonaws.services.identitystore.model.AWSIdentityStoreException;
import com.amazonaws.services.identitystore.model.DescribeGroupRequest;
import com.amazonaws.services.identitystore.model.DescribeGroupResult;
import com.amazonaws.services.identitystore.model.DescribeUserRequest;
import com.amazonaws.services.identitystore.model.DescribeUserResult;
import com.amazonaws.services.identitystore.model.ListGroupsRequest;
import com.amazonaws.services.identitystore.model.ListGroupsResult;
import com.amazonaws.services.identitystore.model.ListUsersRequest;
import com.amazonaws.services.identitystore.model.ListUsersResult;
import com.amazonaws.services.identitystore.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.DescribeGroupRequestProtocolMarshaller;
import com.amazonaws.services.identitystore.model.transform.DescribeGroupResultJsonUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.DescribeUserRequestProtocolMarshaller;
import com.amazonaws.services.identitystore.model.transform.DescribeUserResultJsonUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.ListGroupsRequestProtocolMarshaller;
import com.amazonaws.services.identitystore.model.transform.ListGroupsResultJsonUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.ListUsersRequestProtocolMarshaller;
import com.amazonaws.services.identitystore.model.transform.ListUsersResultJsonUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.identitystore.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIdentityStoreClient
extends AmazonWebServiceClient
implements AWSIdentityStore {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIdentityStore.class);
    private static final String DEFAULT_SIGNING_NAME = "identitystore";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSIdentityStoreException.class));

    public static AWSIdentityStoreClientBuilder builder() {
        return AWSIdentityStoreClientBuilder.standard();
    }

    AWSIdentityStoreClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIdentityStoreClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("identitystore.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/identitystore/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/identitystore/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DescribeGroupResult describeGroup(DescribeGroupRequest request) {
        request = (DescribeGroupRequest)this.beforeClientExecution(request);
        return this.executeDescribeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeGroupResult executeDescribeGroup(DescribeGroupRequest describeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeGroupRequestProtocolMarshaller(protocolFactory).marshall((DescribeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeGroupResult describeGroupResult = (DescribeGroupResult)response.getAwsResponse();
            return describeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUserResult describeUser(DescribeUserRequest request) {
        request = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executeDescribeUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUserResult executeDescribeUser(DescribeUserRequest describeUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUserRequestProtocolMarshaller(protocolFactory).marshall((DescribeUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUserResult describeUserResult = (DescribeUserResult)response.getAwsResponse();
            return describeUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        request = (ListGroupsRequest)this.beforeClientExecution(request);
        return this.executeListGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGroupsResult executeListGroups(ListGroupsRequest listGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGroupsResult listGroupsResult = (ListGroupsResult)response.getAwsResponse();
            return listGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        request = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executeListUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUsersResult executeListUsers(ListUsersRequest listUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUsersRequestProtocolMarshaller(protocolFactory).marshall((ListUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUsers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUsersResult listUsersResult = (ListUsersResult)response.getAwsResponse();
            return listUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

