/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TagOpenIDConnectProviderRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String openIDConnectProviderArn;
    private SdkInternalList<Tag> tags;

    public void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
        this.openIDConnectProviderArn = openIDConnectProviderArn;
    }

    public String getOpenIDConnectProviderArn() {
        return this.openIDConnectProviderArn;
    }

    public TagOpenIDConnectProviderRequest withOpenIDConnectProviderArn(String openIDConnectProviderArn) {
        this.setOpenIDConnectProviderArn(openIDConnectProviderArn);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public TagOpenIDConnectProviderRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public TagOpenIDConnectProviderRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOpenIDConnectProviderArn() != null) {
            sb.append("OpenIDConnectProviderArn: ").append(this.getOpenIDConnectProviderArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagOpenIDConnectProviderRequest)) {
            return false;
        }
        TagOpenIDConnectProviderRequest other = (TagOpenIDConnectProviderRequest)obj;
        if (other.getOpenIDConnectProviderArn() == null ^ this.getOpenIDConnectProviderArn() == null) {
            return false;
        }
        if (other.getOpenIDConnectProviderArn() != null && !other.getOpenIDConnectProviderArn().equals(this.getOpenIDConnectProviderArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOpenIDConnectProviderArn() == null ? 0 : this.getOpenIDConnectProviderArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagOpenIDConnectProviderRequest clone() {
        return (TagOpenIDConnectProviderRequest)super.clone();
    }
}

