/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.services.identitymanagement.model.TagOpenIDConnectProviderRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TagOpenIDConnectProviderRequestMarshaller
implements Marshaller<Request<TagOpenIDConnectProviderRequest>, TagOpenIDConnectProviderRequest> {
    public Request<TagOpenIDConnectProviderRequest> marshall(TagOpenIDConnectProviderRequest tagOpenIDConnectProviderRequest) {
        if (tagOpenIDConnectProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)tagOpenIDConnectProviderRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "TagOpenIDConnectProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagOpenIDConnectProviderRequest.getOpenIDConnectProviderArn() != null) {
            request.addParameter("OpenIDConnectProviderArn", StringUtils.fromString((String)tagOpenIDConnectProviderRequest.getOpenIDConnectProviderArn()));
        }
        if (!tagOpenIDConnectProviderRequest.getTags().isEmpty() || !((SdkInternalList)tagOpenIDConnectProviderRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)tagOpenIDConnectProviderRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

