/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVirtualMFADeviceRequestMarshaller
implements Marshaller<Request<CreateVirtualMFADeviceRequest>, CreateVirtualMFADeviceRequest> {
    public Request<CreateVirtualMFADeviceRequest> marshall(CreateVirtualMFADeviceRequest createVirtualMFADeviceRequest) {
        if (createVirtualMFADeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVirtualMFADeviceRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateVirtualMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVirtualMFADeviceRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createVirtualMFADeviceRequest.getPath()));
        }
        if (createVirtualMFADeviceRequest.getVirtualMFADeviceName() != null) {
            request.addParameter("VirtualMFADeviceName", StringUtils.fromString((String)createVirtualMFADeviceRequest.getVirtualMFADeviceName()));
        }
        if (!createVirtualMFADeviceRequest.getTags().isEmpty() || !((SdkInternalList)createVirtualMFADeviceRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createVirtualMFADeviceRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

