/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.ContextEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimulatePrincipalPolicyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String policySourceArn;
    private ListWithAutoConstructFlag<String> policyInputList;
    private ListWithAutoConstructFlag<String> actionNames;
    private ListWithAutoConstructFlag<String> resourceArns;
    private ListWithAutoConstructFlag<ContextEntry> contextEntries;
    private Integer maxItems;
    private String marker;

    public String getPolicySourceArn() {
        return this.policySourceArn;
    }

    public void setPolicySourceArn(String policySourceArn) {
        this.policySourceArn = policySourceArn;
    }

    public SimulatePrincipalPolicyRequest withPolicySourceArn(String policySourceArn) {
        this.policySourceArn = policySourceArn;
        return this;
    }

    public List<String> getPolicyInputList() {
        if (this.policyInputList == null) {
            this.policyInputList = new ListWithAutoConstructFlag();
            this.policyInputList.setAutoConstruct(true);
        }
        return this.policyInputList;
    }

    public void setPolicyInputList(Collection<String> policyInputList) {
        if (policyInputList == null) {
            this.policyInputList = null;
            return;
        }
        ListWithAutoConstructFlag policyInputListCopy = new ListWithAutoConstructFlag(policyInputList.size());
        policyInputListCopy.addAll(policyInputList);
        this.policyInputList = policyInputListCopy;
    }

    public SimulatePrincipalPolicyRequest withPolicyInputList(String ... policyInputList) {
        if (this.getPolicyInputList() == null) {
            this.setPolicyInputList(new ArrayList<String>(policyInputList.length));
        }
        for (String value : policyInputList) {
            this.getPolicyInputList().add(value);
        }
        return this;
    }

    public SimulatePrincipalPolicyRequest withPolicyInputList(Collection<String> policyInputList) {
        if (policyInputList == null) {
            this.policyInputList = null;
        } else {
            ListWithAutoConstructFlag policyInputListCopy = new ListWithAutoConstructFlag(policyInputList.size());
            policyInputListCopy.addAll(policyInputList);
            this.policyInputList = policyInputListCopy;
        }
        return this;
    }

    public List<String> getActionNames() {
        if (this.actionNames == null) {
            this.actionNames = new ListWithAutoConstructFlag();
            this.actionNames.setAutoConstruct(true);
        }
        return this.actionNames;
    }

    public void setActionNames(Collection<String> actionNames) {
        if (actionNames == null) {
            this.actionNames = null;
            return;
        }
        ListWithAutoConstructFlag actionNamesCopy = new ListWithAutoConstructFlag(actionNames.size());
        actionNamesCopy.addAll(actionNames);
        this.actionNames = actionNamesCopy;
    }

    public SimulatePrincipalPolicyRequest withActionNames(String ... actionNames) {
        if (this.getActionNames() == null) {
            this.setActionNames(new ArrayList<String>(actionNames.length));
        }
        for (String value : actionNames) {
            this.getActionNames().add(value);
        }
        return this;
    }

    public SimulatePrincipalPolicyRequest withActionNames(Collection<String> actionNames) {
        if (actionNames == null) {
            this.actionNames = null;
        } else {
            ListWithAutoConstructFlag actionNamesCopy = new ListWithAutoConstructFlag(actionNames.size());
            actionNamesCopy.addAll(actionNames);
            this.actionNames = actionNamesCopy;
        }
        return this;
    }

    public List<String> getResourceArns() {
        if (this.resourceArns == null) {
            this.resourceArns = new ListWithAutoConstructFlag();
            this.resourceArns.setAutoConstruct(true);
        }
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        ListWithAutoConstructFlag resourceArnsCopy = new ListWithAutoConstructFlag(resourceArns.size());
        resourceArnsCopy.addAll(resourceArns);
        this.resourceArns = resourceArnsCopy;
    }

    public SimulatePrincipalPolicyRequest withResourceArns(String ... resourceArns) {
        if (this.getResourceArns() == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String value : resourceArns) {
            this.getResourceArns().add(value);
        }
        return this;
    }

    public SimulatePrincipalPolicyRequest withResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
        } else {
            ListWithAutoConstructFlag resourceArnsCopy = new ListWithAutoConstructFlag(resourceArns.size());
            resourceArnsCopy.addAll(resourceArns);
            this.resourceArns = resourceArnsCopy;
        }
        return this;
    }

    public List<ContextEntry> getContextEntries() {
        if (this.contextEntries == null) {
            this.contextEntries = new ListWithAutoConstructFlag();
            this.contextEntries.setAutoConstruct(true);
        }
        return this.contextEntries;
    }

    public void setContextEntries(Collection<ContextEntry> contextEntries) {
        if (contextEntries == null) {
            this.contextEntries = null;
            return;
        }
        ListWithAutoConstructFlag contextEntriesCopy = new ListWithAutoConstructFlag(contextEntries.size());
        contextEntriesCopy.addAll(contextEntries);
        this.contextEntries = contextEntriesCopy;
    }

    public SimulatePrincipalPolicyRequest withContextEntries(ContextEntry ... contextEntries) {
        if (this.getContextEntries() == null) {
            this.setContextEntries(new ArrayList<ContextEntry>(contextEntries.length));
        }
        for (ContextEntry value : contextEntries) {
            this.getContextEntries().add(value);
        }
        return this;
    }

    public SimulatePrincipalPolicyRequest withContextEntries(Collection<ContextEntry> contextEntries) {
        if (contextEntries == null) {
            this.contextEntries = null;
        } else {
            ListWithAutoConstructFlag contextEntriesCopy = new ListWithAutoConstructFlag(contextEntries.size());
            contextEntriesCopy.addAll(contextEntries);
            this.contextEntries = contextEntriesCopy;
        }
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public SimulatePrincipalPolicyRequest withMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public SimulatePrincipalPolicyRequest withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicySourceArn() != null) {
            sb.append("PolicySourceArn: " + this.getPolicySourceArn() + ",");
        }
        if (this.getPolicyInputList() != null) {
            sb.append("PolicyInputList: " + this.getPolicyInputList() + ",");
        }
        if (this.getActionNames() != null) {
            sb.append("ActionNames: " + this.getActionNames() + ",");
        }
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: " + this.getResourceArns() + ",");
        }
        if (this.getContextEntries() != null) {
            sb.append("ContextEntries: " + this.getContextEntries() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicySourceArn() == null ? 0 : this.getPolicySourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyInputList() == null ? 0 : this.getPolicyInputList().hashCode());
        hashCode = 31 * hashCode + (this.getActionNames() == null ? 0 : this.getActionNames().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getContextEntries() == null ? 0 : this.getContextEntries().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulatePrincipalPolicyRequest)) {
            return false;
        }
        SimulatePrincipalPolicyRequest other = (SimulatePrincipalPolicyRequest)obj;
        if (other.getPolicySourceArn() == null ^ this.getPolicySourceArn() == null) {
            return false;
        }
        if (other.getPolicySourceArn() != null && !other.getPolicySourceArn().equals(this.getPolicySourceArn())) {
            return false;
        }
        if (other.getPolicyInputList() == null ^ this.getPolicyInputList() == null) {
            return false;
        }
        if (other.getPolicyInputList() != null && !other.getPolicyInputList().equals(this.getPolicyInputList())) {
            return false;
        }
        if (other.getActionNames() == null ^ this.getActionNames() == null) {
            return false;
        }
        if (other.getActionNames() != null && !other.getActionNames().equals(this.getActionNames())) {
            return false;
        }
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getContextEntries() == null ^ this.getContextEntries() == null) {
            return false;
        }
        if (other.getContextEntries() != null && !other.getContextEntries().equals(this.getContextEntries())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        if (other.getMaxItems() != null && !other.getMaxItems().equals(this.getMaxItems())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public SimulatePrincipalPolicyRequest clone() {
        return (SimulatePrincipalPolicyRequest)super.clone();
    }
}

