/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.health.model.AccountEntityAggregate;
import com.amazonaws.services.health.model.transform.OrganizationEntityAggregateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrganizationEntityAggregate
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventArn;
    private Integer count;
    private Map<String, Integer> statuses;
    private List<AccountEntityAggregate> accounts;

    public void setEventArn(String eventArn) {
        this.eventArn = eventArn;
    }

    public String getEventArn() {
        return this.eventArn;
    }

    public OrganizationEntityAggregate withEventArn(String eventArn) {
        this.setEventArn(eventArn);
        return this;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public OrganizationEntityAggregate withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public Map<String, Integer> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Map<String, Integer> statuses) {
        this.statuses = statuses;
    }

    public OrganizationEntityAggregate withStatuses(Map<String, Integer> statuses) {
        this.setStatuses(statuses);
        return this;
    }

    public OrganizationEntityAggregate addStatusesEntry(String key, Integer value) {
        if (null == this.statuses) {
            this.statuses = new HashMap<String, Integer>();
        }
        if (this.statuses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.statuses.put(key, value);
        return this;
    }

    public OrganizationEntityAggregate clearStatusesEntries() {
        this.statuses = null;
        return this;
    }

    public List<AccountEntityAggregate> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<AccountEntityAggregate> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new ArrayList<AccountEntityAggregate>(accounts);
    }

    public OrganizationEntityAggregate withAccounts(AccountEntityAggregate ... accounts) {
        if (this.accounts == null) {
            this.setAccounts(new ArrayList<AccountEntityAggregate>(accounts.length));
        }
        for (AccountEntityAggregate ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    public OrganizationEntityAggregate withAccounts(Collection<AccountEntityAggregate> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventArn() != null) {
            sb.append("EventArn: ").append(this.getEventArn()).append(",");
        }
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getStatuses() != null) {
            sb.append("Statuses: ").append(this.getStatuses()).append(",");
        }
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationEntityAggregate)) {
            return false;
        }
        OrganizationEntityAggregate other = (OrganizationEntityAggregate)obj;
        if (other.getEventArn() == null ^ this.getEventArn() == null) {
            return false;
        }
        if (other.getEventArn() != null && !other.getEventArn().equals(this.getEventArn())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getStatuses() == null ^ this.getStatuses() == null) {
            return false;
        }
        if (other.getStatuses() != null && !other.getStatuses().equals(this.getStatuses())) {
            return false;
        }
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        return other.getAccounts() == null || other.getAccounts().equals(this.getAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventArn() == null ? 0 : this.getEventArn().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getStatuses() == null ? 0 : this.getStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        return hashCode;
    }

    public OrganizationEntityAggregate clone() {
        try {
            return (OrganizationEntityAggregate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrganizationEntityAggregateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

