/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.DescribeEventDetailsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeEventDetailsRequestMarshaller
implements Marshaller<Request<DescribeEventDetailsRequest>, DescribeEventDetailsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeEventDetailsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeEventDetailsRequest> marshall(DescribeEventDetailsRequest describeEventDetailsRequest) {
        if (describeEventDetailsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventDetailsRequest, "AWSHealth");
        request.addHeader("X-Amz-Target", "AWSHealth_20160804.DescribeEventDetails");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> eventArnsList = describeEventDetailsRequest.getEventArns();
            if (eventArnsList != null) {
                jsonGenerator.writeFieldName("eventArns");
                jsonGenerator.writeStartArray();
                for (String eventArnsListValue : eventArnsList) {
                    if (eventArnsListValue == null) continue;
                    jsonGenerator.writeValue(eventArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeEventDetailsRequest.getLocale() != null) {
                jsonGenerator.writeFieldName("locale").writeValue(describeEventDetailsRequest.getLocale());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

