/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model;

import com.amazonaws.services.health.model.Event;
import com.amazonaws.services.health.model.EventDescription;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EventDetails
implements Serializable,
Cloneable {
    private Event event;
    private EventDescription eventDescription;
    private Map<String, String> eventMetadata;

    public void setEvent(Event event) {
        this.event = event;
    }

    public Event getEvent() {
        return this.event;
    }

    public EventDetails withEvent(Event event) {
        this.setEvent(event);
        return this;
    }

    public void setEventDescription(EventDescription eventDescription) {
        this.eventDescription = eventDescription;
    }

    public EventDescription getEventDescription() {
        return this.eventDescription;
    }

    public EventDetails withEventDescription(EventDescription eventDescription) {
        this.setEventDescription(eventDescription);
        return this;
    }

    public Map<String, String> getEventMetadata() {
        return this.eventMetadata;
    }

    public void setEventMetadata(Map<String, String> eventMetadata) {
        this.eventMetadata = eventMetadata;
    }

    public EventDetails withEventMetadata(Map<String, String> eventMetadata) {
        this.setEventMetadata(eventMetadata);
        return this;
    }

    public EventDetails addEventMetadataEntry(String key, String value) {
        if (null == this.eventMetadata) {
            this.eventMetadata = new HashMap<String, String>();
        }
        if (this.eventMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.eventMetadata.put(key, value);
        return this;
    }

    public EventDetails clearEventMetadataEntries() {
        this.eventMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvent() != null) {
            sb.append("Event: " + this.getEvent() + ",");
        }
        if (this.getEventDescription() != null) {
            sb.append("EventDescription: " + this.getEventDescription() + ",");
        }
        if (this.getEventMetadata() != null) {
            sb.append("EventMetadata: " + this.getEventMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDetails)) {
            return false;
        }
        EventDetails other = (EventDetails)obj;
        if (other.getEvent() == null ^ this.getEvent() == null) {
            return false;
        }
        if (other.getEvent() != null && !other.getEvent().equals(this.getEvent())) {
            return false;
        }
        if (other.getEventDescription() == null ^ this.getEventDescription() == null) {
            return false;
        }
        if (other.getEventDescription() != null && !other.getEventDescription().equals(this.getEventDescription())) {
            return false;
        }
        if (other.getEventMetadata() == null ^ this.getEventMetadata() == null) {
            return false;
        }
        return other.getEventMetadata() == null || other.getEventMetadata().equals(this.getEventMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvent() == null ? 0 : this.getEvent().hashCode());
        hashCode = 31 * hashCode + (this.getEventDescription() == null ? 0 : this.getEventDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEventMetadata() == null ? 0 : this.getEventMetadata().hashCode());
        return hashCode;
    }

    public EventDetails clone() {
        try {
            return (EventDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

