/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.DataSource;
import com.amazonaws.services.guardduty.model.UsageFeature;
import com.amazonaws.services.guardduty.model.transform.UsageCriteriaMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UsageCriteria
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> accountIds;
    @Deprecated
    private List<String> dataSources;
    private List<String> resources;
    private List<String> features;

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public UsageCriteria withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public UsageCriteria withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    @Deprecated
    public List<String> getDataSources() {
        return this.dataSources;
    }

    @Deprecated
    public void setDataSources(Collection<String> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<String>(dataSources);
    }

    @Deprecated
    public UsageCriteria withDataSources(String ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<String>(dataSources.length));
        }
        for (String ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    @Deprecated
    public UsageCriteria withDataSources(Collection<String> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    @Deprecated
    public UsageCriteria withDataSources(DataSource ... dataSources) {
        ArrayList<String> dataSourcesCopy = new ArrayList<String>(dataSources.length);
        for (DataSource value : dataSources) {
            dataSourcesCopy.add(value.toString());
        }
        if (this.getDataSources() == null) {
            this.setDataSources(dataSourcesCopy);
        } else {
            this.getDataSources().addAll(dataSourcesCopy);
        }
        return this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<String>(resources);
    }

    public UsageCriteria withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<String>(resources.length));
        }
        for (String ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public UsageCriteria withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<String>(features);
    }

    public UsageCriteria withFeatures(String ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<String>(features.length));
        }
        for (String ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public UsageCriteria withFeatures(Collection<String> features) {
        this.setFeatures(features);
        return this;
    }

    public UsageCriteria withFeatures(UsageFeature ... features) {
        ArrayList<String> featuresCopy = new ArrayList<String>(features.length);
        for (UsageFeature value : features) {
            featuresCopy.add(value.toString());
        }
        if (this.getFeatures() == null) {
            this.setFeatures(featuresCopy);
        } else {
            this.getFeatures().addAll(featuresCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageCriteria)) {
            return false;
        }
        UsageCriteria other = (UsageCriteria)obj;
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        return other.getFeatures() == null || other.getFeatures().equals(this.getFeatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        return hashCode;
    }

    public UsageCriteria clone() {
        try {
            return (UsageCriteria)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UsageCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

