/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.guardduty.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeOrganizationConfigurationResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeOrganizationConfigurationResultJsonUnmarshaller implements Unmarshaller<DescribeOrganizationConfigurationResult, JsonUnmarshallerContext> {

    public DescribeOrganizationConfigurationResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeOrganizationConfigurationResult describeOrganizationConfigurationResult = new DescribeOrganizationConfigurationResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeOrganizationConfigurationResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("autoEnable", targetDepth)) {
                    context.nextToken();
                    describeOrganizationConfigurationResult.setAutoEnable(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("memberAccountLimitReached", targetDepth)) {
                    context.nextToken();
                    describeOrganizationConfigurationResult.setMemberAccountLimitReached(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("dataSources", targetDepth)) {
                    context.nextToken();
                    describeOrganizationConfigurationResult.setDataSources(OrganizationDataSourceConfigurationsResultJsonUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("features", targetDepth)) {
                    context.nextToken();
                    describeOrganizationConfigurationResult.setFeatures(new ListUnmarshaller<OrganizationFeatureConfigurationResult>(
                            OrganizationFeatureConfigurationResultJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("nextToken", targetDepth)) {
                    context.nextToken();
                    describeOrganizationConfigurationResult.setNextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("autoEnableOrganizationMembers", targetDepth)) {
                    context.nextToken();
                    describeOrganizationConfigurationResult.setAutoEnableOrganizationMembers(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeOrganizationConfigurationResult;
    }

    private static DescribeOrganizationConfigurationResultJsonUnmarshaller instance;

    public static DescribeOrganizationConfigurationResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeOrganizationConfigurationResultJsonUnmarshaller();
        return instance;
    }
}
