/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.ComponentType;
import com.amazonaws.services.groundstation.model.transform.ComponentVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentType;
    private List<String> versions;

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public ComponentVersion withComponentType(String componentType) {
        this.setComponentType(componentType);
        return this;
    }

    public ComponentVersion withComponentType(ComponentType componentType) {
        this.componentType = componentType.toString();
        return this;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<String> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<String>(versions);
    }

    public ComponentVersion withVersions(String ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<String>(versions.length));
        }
        for (String ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public ComponentVersion withVersions(Collection<String> versions) {
        this.setVersions(versions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentType() != null) {
            sb.append("ComponentType: ").append(this.getComponentType()).append(",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVersion)) {
            return false;
        }
        ComponentVersion other = (ComponentVersion)obj;
        if (other.getComponentType() == null ^ this.getComponentType() == null) {
            return false;
        }
        if (other.getComponentType() != null && !other.getComponentType().equals(this.getComponentType())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        return other.getVersions() == null || other.getVersions().equals(this.getVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentType() == null ? 0 : this.getComponentType().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        return hashCode;
    }

    public ComponentVersion clone() {
        try {
            return (ComponentVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

