/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.SpectrumConfig;

@SdkInternalApi
public class SpectrumConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").build();
    private static final MarshallingInfo<StructuredPojo> CENTERFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("centerFrequency").build();
    private static final MarshallingInfo<String> POLARIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("polarization").build();
    private static final SpectrumConfigMarshaller instance = new SpectrumConfigMarshaller();

    public static SpectrumConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(SpectrumConfig spectrumConfig, ProtocolMarshaller protocolMarshaller) {
        if (spectrumConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)spectrumConfig.getBandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)spectrumConfig.getCenterFrequency(), CENTERFREQUENCY_BINDING);
            protocolMarshaller.marshall((Object)spectrumConfig.getPolarization(), POLARIZATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

