/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.Deployment;
import java.util.Date;

@SdkInternalApi
public class DeploymentMarshaller {
    private static final MarshallingInfo<String> TARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArn").build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionId").build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").build();
    private static final MarshallingInfo<String> DEPLOYMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentName").build();
    private static final MarshallingInfo<Date> CREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DEPLOYMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentStatus").build();
    private static final MarshallingInfo<Boolean> ISLATESTFORTARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isLatestForTarget").build();
    private static final MarshallingInfo<String> PARENTTARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentTargetArn").build();
    private static final DeploymentMarshaller instance = new DeploymentMarshaller();

    public static DeploymentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Deployment deployment, ProtocolMarshaller protocolMarshaller) {
        if (deployment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deployment.getTargetArn(), TARGETARN_BINDING);
            protocolMarshaller.marshall((Object)deployment.getRevisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall((Object)deployment.getDeploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)deployment.getDeploymentName(), DEPLOYMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)deployment.getCreationTimestamp(), CREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)deployment.getDeploymentStatus(), DEPLOYMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)deployment.getIsLatestForTarget(), ISLATESTFORTARGET_BINDING);
            protocolMarshaller.marshall((Object)deployment.getParentTargetArn(), PARENTTARGETARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

