/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrass.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrass.model.transform.ConnectorMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Connector
implements Serializable,
Cloneable,
StructuredPojo {
    private String connectorArn;
    private String id;
    private Map<String, String> parameters;

    public void setConnectorArn(String connectorArn) {
        this.connectorArn = connectorArn;
    }

    public String getConnectorArn() {
        return this.connectorArn;
    }

    public Connector withConnectorArn(String connectorArn) {
        this.setConnectorArn(connectorArn);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Connector withId(String id) {
        this.setId(id);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Connector withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Connector addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Connector clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectorArn() != null) {
            sb.append("ConnectorArn: ").append(this.getConnectorArn()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)obj;
        if (other.getConnectorArn() == null ^ this.getConnectorArn() == null) {
            return false;
        }
        if (other.getConnectorArn() != null && !other.getConnectorArn().equals(this.getConnectorArn())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectorArn() == null ? 0 : this.getConnectorArn().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public Connector clone() {
        try {
            return (Connector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

