/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.Output;
import java.util.List;

@SdkInternalApi
public class OutputMarshaller {
    private static final MarshallingInfo<String> COMPRESSIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompressionFormat").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").build();
    private static final MarshallingInfo<List> PARTITIONCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionColumns").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").build();
    private static final MarshallingInfo<Boolean> OVERWRITE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Overwrite").build();
    private static final MarshallingInfo<StructuredPojo> FORMATOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FormatOptions").build();
    private static final MarshallingInfo<Integer> MAXOUTPUTFILES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxOutputFiles").build();
    private static final OutputMarshaller instance = new OutputMarshaller();

    public static OutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Output output, ProtocolMarshaller protocolMarshaller) {
        if (output == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)output.getCompressionFormat(), COMPRESSIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)output.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall(output.getPartitionColumns(), PARTITIONCOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)output.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)output.getOverwrite(), OVERWRITE_BINDING);
            protocolMarshaller.marshall((Object)output.getFormatOptions(), FORMATOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)output.getMaxOutputFiles(), MAXOUTPUTFILES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

