/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.StatisticOverride;
import com.amazonaws.services.gluedatabrew.model.transform.StatisticsConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatisticsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> includedStatistics;
    private List<StatisticOverride> overrides;

    public List<String> getIncludedStatistics() {
        return this.includedStatistics;
    }

    public void setIncludedStatistics(Collection<String> includedStatistics) {
        if (includedStatistics == null) {
            this.includedStatistics = null;
            return;
        }
        this.includedStatistics = new ArrayList<String>(includedStatistics);
    }

    public StatisticsConfiguration withIncludedStatistics(String ... includedStatistics) {
        if (this.includedStatistics == null) {
            this.setIncludedStatistics(new ArrayList<String>(includedStatistics.length));
        }
        for (String ele : includedStatistics) {
            this.includedStatistics.add(ele);
        }
        return this;
    }

    public StatisticsConfiguration withIncludedStatistics(Collection<String> includedStatistics) {
        this.setIncludedStatistics(includedStatistics);
        return this;
    }

    public List<StatisticOverride> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Collection<StatisticOverride> overrides) {
        if (overrides == null) {
            this.overrides = null;
            return;
        }
        this.overrides = new ArrayList<StatisticOverride>(overrides);
    }

    public StatisticsConfiguration withOverrides(StatisticOverride ... overrides) {
        if (this.overrides == null) {
            this.setOverrides(new ArrayList<StatisticOverride>(overrides.length));
        }
        for (StatisticOverride ele : overrides) {
            this.overrides.add(ele);
        }
        return this;
    }

    public StatisticsConfiguration withOverrides(Collection<StatisticOverride> overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIncludedStatistics() != null) {
            sb.append("IncludedStatistics: ").append(this.getIncludedStatistics()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticsConfiguration)) {
            return false;
        }
        StatisticsConfiguration other = (StatisticsConfiguration)obj;
        if (other.getIncludedStatistics() == null ^ this.getIncludedStatistics() == null) {
            return false;
        }
        if (other.getIncludedStatistics() != null && !other.getIncludedStatistics().equals(this.getIncludedStatistics())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        return other.getOverrides() == null || other.getOverrides().equals(this.getOverrides());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIncludedStatistics() == null ? 0 : this.getIncludedStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        return hashCode;
    }

    public StatisticsConfiguration clone() {
        try {
            return (StatisticsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StatisticsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

