/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.Input;

@SdkInternalApi
public class InputMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3INPUTDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3InputDefinition").build();
    private static final MarshallingInfo<StructuredPojo> DATACATALOGINPUTDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataCatalogInputDefinition").build();
    private static final MarshallingInfo<StructuredPojo> DATABASEINPUTDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseInputDefinition").build();
    private static final MarshallingInfo<StructuredPojo> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metadata").build();
    private static final InputMarshaller instance = new InputMarshaller();

    public static InputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Input input, ProtocolMarshaller protocolMarshaller) {
        if (input == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)input.getS3InputDefinition(), S3INPUTDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)input.getDataCatalogInputDefinition(), DATACATALOGINPUTDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)input.getDatabaseInputDefinition(), DATABASEINPUTDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)input.getMetadata(), METADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

