/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gluedatabrew.model.ExcelOptions;
import java.util.List;

@SdkInternalApi
public class ExcelOptionsMarshaller {
    private static final MarshallingInfo<List> SHEETNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SheetNames").build();
    private static final MarshallingInfo<List> SHEETINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SheetIndexes").build();
    private static final ExcelOptionsMarshaller instance = new ExcelOptionsMarshaller();

    public static ExcelOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExcelOptions excelOptions, ProtocolMarshaller protocolMarshaller) {
        if (excelOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(excelOptions.getSheetNames(), SHEETNAMES_BINDING);
            protocolMarshaller.marshall(excelOptions.getSheetIndexes(), SHEETINDEXES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

