/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.FormatOptions;

@SdkInternalApi
public class FormatOptionsMarshaller {
    private static final MarshallingInfo<StructuredPojo> JSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Json").build();
    private static final MarshallingInfo<StructuredPojo> EXCEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Excel").build();
    private static final FormatOptionsMarshaller instance = new FormatOptionsMarshaller();

    public static FormatOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(FormatOptions formatOptions, ProtocolMarshaller protocolMarshaller) {
        if (formatOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)formatOptions.getJson(), JSON_BINDING);
            protocolMarshaller.marshall((Object)formatOptions.getExcel(), EXCEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

