/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.transform.ExcelOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExcelOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> sheetNames;
    private List<Integer> sheetIndexes;

    public List<String> getSheetNames() {
        return this.sheetNames;
    }

    public void setSheetNames(Collection<String> sheetNames) {
        if (sheetNames == null) {
            this.sheetNames = null;
            return;
        }
        this.sheetNames = new ArrayList<String>(sheetNames);
    }

    public ExcelOptions withSheetNames(String ... sheetNames) {
        if (this.sheetNames == null) {
            this.setSheetNames(new ArrayList<String>(sheetNames.length));
        }
        for (String ele : sheetNames) {
            this.sheetNames.add(ele);
        }
        return this;
    }

    public ExcelOptions withSheetNames(Collection<String> sheetNames) {
        this.setSheetNames(sheetNames);
        return this;
    }

    public List<Integer> getSheetIndexes() {
        return this.sheetIndexes;
    }

    public void setSheetIndexes(Collection<Integer> sheetIndexes) {
        if (sheetIndexes == null) {
            this.sheetIndexes = null;
            return;
        }
        this.sheetIndexes = new ArrayList<Integer>(sheetIndexes);
    }

    public ExcelOptions withSheetIndexes(Integer ... sheetIndexes) {
        if (this.sheetIndexes == null) {
            this.setSheetIndexes(new ArrayList<Integer>(sheetIndexes.length));
        }
        for (Integer ele : sheetIndexes) {
            this.sheetIndexes.add(ele);
        }
        return this;
    }

    public ExcelOptions withSheetIndexes(Collection<Integer> sheetIndexes) {
        this.setSheetIndexes(sheetIndexes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSheetNames() != null) {
            sb.append("SheetNames: ").append(this.getSheetNames()).append(",");
        }
        if (this.getSheetIndexes() != null) {
            sb.append("SheetIndexes: ").append(this.getSheetIndexes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExcelOptions)) {
            return false;
        }
        ExcelOptions other = (ExcelOptions)obj;
        if (other.getSheetNames() == null ^ this.getSheetNames() == null) {
            return false;
        }
        if (other.getSheetNames() != null && !other.getSheetNames().equals(this.getSheetNames())) {
            return false;
        }
        if (other.getSheetIndexes() == null ^ this.getSheetIndexes() == null) {
            return false;
        }
        return other.getSheetIndexes() == null || other.getSheetIndexes().equals(this.getSheetIndexes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSheetNames() == null ? 0 : this.getSheetNames().hashCode());
        hashCode = 31 * hashCode + (this.getSheetIndexes() == null ? 0 : this.getSheetIndexes().hashCode());
        return hashCode;
    }

    public ExcelOptions clone() {
        try {
            return (ExcelOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExcelOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

