/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.OAuth2ClientApplication;
import com.amazonaws.services.glue.model.OAuth2GrantType;
import com.amazonaws.services.glue.model.transform.OAuth2PropertiesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OAuth2Properties
implements Serializable,
Cloneable,
StructuredPojo {
    private String oAuth2GrantType;
    private OAuth2ClientApplication oAuth2ClientApplication;
    private String tokenUrl;
    private Map<String, String> tokenUrlParametersMap;

    public void setOAuth2GrantType(String oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType;
    }

    public String getOAuth2GrantType() {
        return this.oAuth2GrantType;
    }

    public OAuth2Properties withOAuth2GrantType(String oAuth2GrantType) {
        this.setOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    public OAuth2Properties withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType.toString();
        return this;
    }

    public void setOAuth2ClientApplication(OAuth2ClientApplication oAuth2ClientApplication) {
        this.oAuth2ClientApplication = oAuth2ClientApplication;
    }

    public OAuth2ClientApplication getOAuth2ClientApplication() {
        return this.oAuth2ClientApplication;
    }

    public OAuth2Properties withOAuth2ClientApplication(OAuth2ClientApplication oAuth2ClientApplication) {
        this.setOAuth2ClientApplication(oAuth2ClientApplication);
        return this;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuth2Properties withTokenUrl(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        return this;
    }

    public Map<String, String> getTokenUrlParametersMap() {
        return this.tokenUrlParametersMap;
    }

    public void setTokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
        this.tokenUrlParametersMap = tokenUrlParametersMap;
    }

    public OAuth2Properties withTokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
        this.setTokenUrlParametersMap(tokenUrlParametersMap);
        return this;
    }

    public OAuth2Properties addTokenUrlParametersMapEntry(String key, String value) {
        if (null == this.tokenUrlParametersMap) {
            this.tokenUrlParametersMap = new HashMap<String, String>();
        }
        if (this.tokenUrlParametersMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tokenUrlParametersMap.put(key, value);
        return this;
    }

    public OAuth2Properties clearTokenUrlParametersMapEntries() {
        this.tokenUrlParametersMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOAuth2GrantType() != null) {
            sb.append("OAuth2GrantType: ").append(this.getOAuth2GrantType()).append(",");
        }
        if (this.getOAuth2ClientApplication() != null) {
            sb.append("OAuth2ClientApplication: ").append(this.getOAuth2ClientApplication()).append(",");
        }
        if (this.getTokenUrl() != null) {
            sb.append("TokenUrl: ").append(this.getTokenUrl()).append(",");
        }
        if (this.getTokenUrlParametersMap() != null) {
            sb.append("TokenUrlParametersMap: ").append(this.getTokenUrlParametersMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Properties)) {
            return false;
        }
        OAuth2Properties other = (OAuth2Properties)obj;
        if (other.getOAuth2GrantType() == null ^ this.getOAuth2GrantType() == null) {
            return false;
        }
        if (other.getOAuth2GrantType() != null && !other.getOAuth2GrantType().equals(this.getOAuth2GrantType())) {
            return false;
        }
        if (other.getOAuth2ClientApplication() == null ^ this.getOAuth2ClientApplication() == null) {
            return false;
        }
        if (other.getOAuth2ClientApplication() != null && !other.getOAuth2ClientApplication().equals(this.getOAuth2ClientApplication())) {
            return false;
        }
        if (other.getTokenUrl() == null ^ this.getTokenUrl() == null) {
            return false;
        }
        if (other.getTokenUrl() != null && !other.getTokenUrl().equals(this.getTokenUrl())) {
            return false;
        }
        if (other.getTokenUrlParametersMap() == null ^ this.getTokenUrlParametersMap() == null) {
            return false;
        }
        return other.getTokenUrlParametersMap() == null || other.getTokenUrlParametersMap().equals(this.getTokenUrlParametersMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOAuth2GrantType() == null ? 0 : this.getOAuth2GrantType().hashCode());
        hashCode = 31 * hashCode + (this.getOAuth2ClientApplication() == null ? 0 : this.getOAuth2ClientApplication().hashCode());
        hashCode = 31 * hashCode + (this.getTokenUrl() == null ? 0 : this.getTokenUrl().hashCode());
        hashCode = 31 * hashCode + (this.getTokenUrlParametersMap() == null ? 0 : this.getTokenUrlParametersMap().hashCode());
        return hashCode;
    }

    public OAuth2Properties clone() {
        try {
            return (OAuth2Properties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OAuth2PropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

