/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glue.model.UsageProfileDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListUsageProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<UsageProfileDefinition> profiles;
    private String nextToken;

    public List<UsageProfileDefinition> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Collection<UsageProfileDefinition> profiles) {
        if (profiles == null) {
            this.profiles = null;
            return;
        }
        this.profiles = new ArrayList<UsageProfileDefinition>(profiles);
    }

    public ListUsageProfilesResult withProfiles(UsageProfileDefinition ... profiles) {
        if (this.profiles == null) {
            this.setProfiles(new ArrayList<UsageProfileDefinition>(profiles.length));
        }
        for (UsageProfileDefinition ele : profiles) {
            this.profiles.add(ele);
        }
        return this;
    }

    public ListUsageProfilesResult withProfiles(Collection<UsageProfileDefinition> profiles) {
        this.setProfiles(profiles);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListUsageProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfiles() != null) {
            sb.append("Profiles: ").append(this.getProfiles()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageProfilesResult)) {
            return false;
        }
        ListUsageProfilesResult other = (ListUsageProfilesResult)obj;
        if (other.getProfiles() == null ^ this.getProfiles() == null) {
            return false;
        }
        if (other.getProfiles() != null && !other.getProfiles().equals(this.getProfiles())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfiles() == null ? 0 : this.getProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListUsageProfilesResult clone() {
        try {
            return (ListUsageProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

