/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.FilterOperation;
import com.amazonaws.services.glue.model.FilterValue;
import com.amazonaws.services.glue.model.transform.FilterExpressionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterExpression
implements Serializable,
Cloneable,
StructuredPojo {
    private String operation;
    private Boolean negated;
    private List<FilterValue> values;

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public FilterExpression withOperation(String operation) {
        this.setOperation(operation);
        return this;
    }

    public FilterExpression withOperation(FilterOperation operation) {
        this.operation = operation.toString();
        return this;
    }

    public void setNegated(Boolean negated) {
        this.negated = negated;
    }

    public Boolean getNegated() {
        return this.negated;
    }

    public FilterExpression withNegated(Boolean negated) {
        this.setNegated(negated);
        return this;
    }

    public Boolean isNegated() {
        return this.negated;
    }

    public List<FilterValue> getValues() {
        return this.values;
    }

    public void setValues(Collection<FilterValue> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<FilterValue>(values);
    }

    public FilterExpression withValues(FilterValue ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<FilterValue>(values.length));
        }
        for (FilterValue ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public FilterExpression withValues(Collection<FilterValue> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperation() != null) {
            sb.append("Operation: ").append(this.getOperation()).append(",");
        }
        if (this.getNegated() != null) {
            sb.append("Negated: ").append(this.getNegated()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterExpression)) {
            return false;
        }
        FilterExpression other = (FilterExpression)obj;
        if (other.getOperation() == null ^ this.getOperation() == null) {
            return false;
        }
        if (other.getOperation() != null && !other.getOperation().equals(this.getOperation())) {
            return false;
        }
        if (other.getNegated() == null ^ this.getNegated() == null) {
            return false;
        }
        if (other.getNegated() != null && !other.getNegated().equals(this.getNegated())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperation() == null ? 0 : this.getOperation().hashCode());
        hashCode = 31 * hashCode + (this.getNegated() == null ? 0 : this.getNegated().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public FilterExpression clone() {
        try {
            return (FilterExpression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

