/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.CrawlerHistory;
import java.util.Date;

@SdkInternalApi
public class CrawlerHistoryMarshaller {
    private static final MarshallingInfo<String> CRAWLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Summary").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<String> LOGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroup").build();
    private static final MarshallingInfo<String> LOGSTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStream").build();
    private static final MarshallingInfo<String> MESSAGEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessagePrefix").build();
    private static final MarshallingInfo<Double> DPUHOUR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DPUHour").build();
    private static final CrawlerHistoryMarshaller instance = new CrawlerHistoryMarshaller();

    public static CrawlerHistoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(CrawlerHistory crawlerHistory, ProtocolMarshaller protocolMarshaller) {
        if (crawlerHistory == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)crawlerHistory.getCrawlId(), CRAWLID_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getSummary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getLogGroup(), LOGGROUP_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getLogStream(), LOGSTREAM_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getMessagePrefix(), MESSAGEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)crawlerHistory.getDPUHour(), DPUHOUR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

