/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.S3Target;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3TargetJsonUnmarshaller
implements Unmarshaller<S3Target, JsonUnmarshallerContext> {
    private static S3TargetJsonUnmarshaller instance;

    public S3Target unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Target s3Target = new S3Target();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Path", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Target.setPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Exclusions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Target.setExclusions(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ConnectionName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Target.setConnectionName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SampleSize", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Target.setSampleSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("EventQueueArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Target.setEventQueueArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DlqEventQueueArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Target.setDlqEventQueueArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Target;
    }

    public static S3TargetJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3TargetJsonUnmarshaller();
        }
        return instance;
    }
}

