/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.transform.DatabaseIdentifierJsonUnmarshaller;
import com.amazonaws.services.glue.model.transform.PrincipalPermissionsJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DatabaseJsonUnmarshaller
implements Unmarshaller<Database, JsonUnmarshallerContext> {
    private static DatabaseJsonUnmarshaller instance;

    public Database unmarshall(JsonUnmarshallerContext context) throws Exception {
        Database database = new Database();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    database.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    database.setDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LocationUri", targetDepth)) {
                    context.nextToken();
                    database.setLocationUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    database.setParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    context.nextToken();
                    database.setCreateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("CreateTableDefaultPermissions", targetDepth)) {
                    context.nextToken();
                    database.setCreateTableDefaultPermissions(new ListUnmarshaller((Unmarshaller)PrincipalPermissionsJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("TargetDatabase", targetDepth)) {
                    context.nextToken();
                    database.setTargetDatabase(DatabaseIdentifierJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CatalogId", targetDepth)) {
                    context.nextToken();
                    database.setCatalogId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return database;
    }

    public static DatabaseJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatabaseJsonUnmarshaller();
        }
        return instance;
    }
}

