/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.CustomEntityType;
import java.util.List;

@SdkInternalApi
public class CustomEntityTypeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> REGEXSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegexString").build();
    private static final MarshallingInfo<List> CONTEXTWORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContextWords").build();
    private static final CustomEntityTypeMarshaller instance = new CustomEntityTypeMarshaller();

    public static CustomEntityTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomEntityType customEntityType, ProtocolMarshaller protocolMarshaller) {
        if (customEntityType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)customEntityType.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)customEntityType.getRegexString(), REGEXSTRING_BINDING);
            protocolMarshaller.marshall(customEntityType.getContextWords(), CONTEXTWORDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

