/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Blueprint;
import java.util.Date;

@SdkInternalApi
public class BlueprintMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Date> CREATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> PARAMETERSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterSpec").build();
    private static final MarshallingInfo<String> BLUEPRINTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlueprintLocation").build();
    private static final MarshallingInfo<String> BLUEPRINTSERVICELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlueprintServiceLocation").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<StructuredPojo> LASTACTIVEDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastActiveDefinition").build();
    private static final BlueprintMarshaller instance = new BlueprintMarshaller();

    public static BlueprintMarshaller getInstance() {
        return instance;
    }

    public void marshall(Blueprint blueprint, ProtocolMarshaller protocolMarshaller) {
        if (blueprint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)blueprint.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getCreatedOn(), CREATEDON_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getLastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getParameterSpec(), PARAMETERSPEC_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getBlueprintLocation(), BLUEPRINTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getBlueprintServiceLocation(), BLUEPRINTSERVICELOCATION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.getLastActiveDefinition(), LASTACTIVEDEFINITION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

