/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Edge;
import com.amazonaws.services.glue.model.Node;
import com.amazonaws.services.glue.model.transform.WorkflowGraphMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkflowGraph
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Node> nodes;
    private List<Edge> edges;

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Collection<Node> nodes) {
        if (nodes == null) {
            this.nodes = null;
            return;
        }
        this.nodes = new ArrayList<Node>(nodes);
    }

    public WorkflowGraph withNodes(Node ... nodes) {
        if (this.nodes == null) {
            this.setNodes(new ArrayList<Node>(nodes.length));
        }
        for (Node ele : nodes) {
            this.nodes.add(ele);
        }
        return this;
    }

    public WorkflowGraph withNodes(Collection<Node> nodes) {
        this.setNodes(nodes);
        return this;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(Collection<Edge> edges) {
        if (edges == null) {
            this.edges = null;
            return;
        }
        this.edges = new ArrayList<Edge>(edges);
    }

    public WorkflowGraph withEdges(Edge ... edges) {
        if (this.edges == null) {
            this.setEdges(new ArrayList<Edge>(edges.length));
        }
        for (Edge ele : edges) {
            this.edges.add(ele);
        }
        return this;
    }

    public WorkflowGraph withEdges(Collection<Edge> edges) {
        this.setEdges(edges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNodes() != null) {
            sb.append("Nodes: ").append(this.getNodes()).append(",");
        }
        if (this.getEdges() != null) {
            sb.append("Edges: ").append(this.getEdges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowGraph)) {
            return false;
        }
        WorkflowGraph other = (WorkflowGraph)obj;
        if (other.getNodes() == null ^ this.getNodes() == null) {
            return false;
        }
        if (other.getNodes() != null && !other.getNodes().equals(this.getNodes())) {
            return false;
        }
        if (other.getEdges() == null ^ this.getEdges() == null) {
            return false;
        }
        return other.getEdges() == null || other.getEdges().equals(this.getEdges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNodes() == null ? 0 : this.getNodes().hashCode());
        hashCode = 31 * hashCode + (this.getEdges() == null ? 0 : this.getEdges().hashCode());
        return hashCode;
    }

    public WorkflowGraph clone() {
        try {
            return (WorkflowGraph)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowGraphMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

